/*
 * Decompiled with CFR 0.152.
 */
package ch.sparkpudding.sceneeditor.panel.modal;

import ch.sparkpudding.sceneeditor.SceneEditor;
import ch.sparkpudding.sceneeditor.action.ActionAddSystem;
import ch.sparkpudding.sceneeditor.panel.modal.Modal;
import java.awt.FlowLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JTextField;

public class ModalSystem
extends Modal {
    private JLabel labelName;
    private JTextField textFieldName;
    private JButton buttonAdd;
    private JButton buttonCancel;

    public ModalSystem() {
        super(SceneEditor.frameSceneEditor, "New system", (Boolean)true);
        this.init();
        this.setupLayout();
        this.setupListener();
        this.setupFrame();
    }

    private void init() {
        this.labelName = new JLabel("Name :");
        this.textFieldName = new JTextField(15);
        this.buttonCancel = new JButton("Cancel");
        this.buttonAdd = new JButton("Add");
        this.buttonAdd.setEnabled(false);
    }

    private void setupLayout() {
        this.mainPanel.setLayout(new FlowLayout(1));
        this.mainPanel.add(this.labelName);
        this.mainPanel.add(this.textFieldName);
        this.mainPanel.add(this.buttonAdd);
        this.mainPanel.add(this.buttonCancel);
    }

    private void setupFrame() {
        this.pack();
        this.setResizable(false);
        this.setLocationRelativeTo(null);
        this.setVisible(true);
    }

    private void setupListener() {
        this.textFieldName.addKeyListener(new KeyAdapter(){

            @Override
            public void keyReleased(KeyEvent e) {
                if (e.getKeyCode() == 27) {
                    ModalSystem.this.dispose();
                }
                ModalSystem.this.buttonAdd.setEnabled(ModalSystem.this.textFieldName.getText().length() > 0);
            }
        });
        this.buttonAdd.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                String name = ModalSystem.this.textFieldName.getText();
                new ActionAddSystem(name).actionPerformed(e);
                ModalSystem.this.dispose();
            }
        });
        this.buttonCancel.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ModalSystem.this.dispose();
            }
        });
        this.textFieldName.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ModalSystem.this.buttonAdd.doClick();
            }
        });
    }
}

