/*
 * Decompiled with CFR 0.152.
 */
package ch.sparkpudding.sceneeditor.panel.modal;

import ch.sparkpudding.coreengine.CoreEngine;
import ch.sparkpudding.coreengine.Scheduler;
import ch.sparkpudding.coreengine.utils.RunnableOneParameter;
import ch.sparkpudding.sceneeditor.FrameSceneEditor;
import ch.sparkpudding.sceneeditor.SceneEditor;
import ch.sparkpudding.sceneeditor.filewriter.LelWriter;
import ch.sparkpudding.sceneeditor.panel.modal.Modal;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.File;
import java.io.FileNotFoundException;
import java.net.URI;
import java.net.URISyntaxException;
import java.nio.file.FileSystemNotFoundException;
import java.nio.file.Paths;
import java.nio.file.spi.FileSystemProvider;
import java.util.Collections;
import javax.swing.JButton;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JOptionPane;

public class ModalStart
extends Modal {
    private String gamePath;
    private boolean gameStarted;
    private JButton btnOpen;
    private JButton btnNewEmpty;
    private JButton btnNewBasic;

    public ModalStart() {
        super((JFrame)null, "Create or open game", (Boolean)false);
        this.init();
        this.setupLayout();
        this.setupListener();
        this.setupFrame();
    }

    private void init() {
        this.gameStarted = false;
        this.btnOpen = new JButton("Open");
        this.btnNewEmpty = new JButton("New empty game");
        this.btnNewBasic = new JButton("New basic game");
    }

    private void setupLayout() {
        this.mainPanel.setLayout(new BorderLayout());
        this.mainPanel.add((Component)this.btnOpen, "North");
        this.mainPanel.add((Component)this.btnNewEmpty, "Center");
        this.mainPanel.add((Component)this.btnNewBasic, "South");
    }

    private void setupFrame() {
        this.pack();
        this.setResizable(false);
        this.setLocationRelativeTo(null);
        this.setVisible(true);
    }

    private void setupListener() {
        this.btnOpen.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                JFileChooser fc = new JFileChooser();
                fc.setFileSelectionMode(1);
                fc.setCurrentDirectory(new File(System.getProperty("user.dir")));
                int returnVal = fc.showOpenDialog(null);
                if (returnVal != 0) {
                    return;
                }
                ModalStart.this.gamePath = fc.getSelectedFile().getAbsolutePath();
                ModalStart.this.openGame();
            }
        });
        this.btnNewBasic.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                JFileChooser fc = new JFileChooser();
                fc.setFileSelectionMode(1);
                fc.setCurrentDirectory(new File(System.getProperty("user.dir")));
                int returnVal = fc.showSaveDialog(null);
                if (returnVal != 0) {
                    return;
                }
                ModalStart.this.gamePath = fc.getSelectedFile().getAbsolutePath();
                LelWriter lel = new LelWriter();
                lel.create(String.valueOf(ModalStart.this.gamePath) + '/', false);
                ModalStart.this.openGame();
            }
        });
        this.btnNewEmpty.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                JFileChooser fc = new JFileChooser();
                fc.setFileSelectionMode(1);
                fc.setCurrentDirectory(new File(System.getProperty("user.dir")));
                int returnVal = fc.showSaveDialog(null);
                if (returnVal != 0) {
                    return;
                }
                ModalStart.this.gamePath = fc.getSelectedFile().getAbsolutePath();
                LelWriter lel = new LelWriter();
                lel.create(String.valueOf(ModalStart.this.gamePath) + '/', true);
                ModalStart.this.openGame();
            }
        });
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent e) {
                if (!ModalStart.this.gameStarted) {
                    System.exit(0);
                }
            }
        });
    }

    private void openGame() {
        try {
            URI uri = Paths.get("./resources/leleditor", new String[0]).toUri();
            if ("jar".equals(uri.getScheme())) {
                for (FileSystemProvider provider : FileSystemProvider.installedProviders()) {
                    if (!provider.getScheme().equalsIgnoreCase("jar")) continue;
                    try {
                        provider.getFileSystem(uri);
                    }
                    catch (FileSystemNotFoundException e) {
                        provider.newFileSystem(uri, Collections.emptyMap());
                    }
                }
            }
            SceneEditor.coreEngine = new CoreEngine(this.gamePath, Paths.get("./resources/leleditor", new String[0]).toString());
        }
        catch (URISyntaxException e) {
            JOptionPane.showMessageDialog(this.mainPanel, "Invalid path", "Error during editor startup", 0);
            return;
        }
        catch (FileNotFoundException e) {
            JOptionPane.showMessageDialog(this.mainPanel, "No games found at this location.", "Error during editor startup", 0);
        }
        catch (Exception e) {
            JOptionPane.showMessageDialog(this.mainPanel, "Cannot open game. Error: \n\n" + e.getMessage() + "\n\nCheck the console for more details.", "Error during editor startup", 0);
            e.printStackTrace();
            return;
        }
        SceneEditor.gamePath = this.gamePath;
        SceneEditor.coreEngine.getScheduler().notify(Scheduler.Trigger.EDITING_STATE_CHANGED, new RunnableOneParameter(){

            @Override
            public void run() {
                if (SceneEditor.coreEngine.isInError()) {
                    SceneEditor.setGameState(SceneEditor.EditorState.ERROR);
                } else if (((Boolean)this.getObject()).booleanValue()) {
                    SceneEditor.setGameState(SceneEditor.EditorState.PAUSE);
                } else {
                    SceneEditor.setGameState(SceneEditor.EditorState.PLAY);
                }
            }
        });
        SceneEditor.frameSceneEditor = new FrameSceneEditor();
        this.gameStarted = true;
        this.dispose();
    }
}

