/*
 * Decompiled with CFR 0.152.
 */
package ch.sparkpudding.sceneeditor.panel.modal;

import ch.sparkpudding.sceneeditor.SceneEditor;
import ch.sparkpudding.sceneeditor.action.ActionAddScene;
import ch.sparkpudding.sceneeditor.panel.modal.Modal;
import java.awt.FlowLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JTextField;

public class ModalScene
extends Modal {
    private JLabel lblName;
    private JTextField fiName;
    private JButton btnAdd;

    public ModalScene() {
        super(SceneEditor.frameSceneEditor, "New scene", (Boolean)true);
        this.init();
        this.setupLayout();
        this.setupListener();
        this.setupFrame();
    }

    private void init() {
        this.lblName = new JLabel("Name :");
        this.fiName = new JTextField(15);
        this.btnAdd = new JButton("Add");
        this.btnAdd.setEnabled(false);
    }

    private void setupLayout() {
        this.mainPanel.setLayout(new FlowLayout(1));
        this.mainPanel.add(this.lblName);
        this.mainPanel.add(this.fiName);
        this.mainPanel.add(this.btnAdd);
    }

    private void setupFrame() {
        this.pack();
        this.setResizable(false);
        this.setLocationRelativeTo(null);
        this.setVisible(true);
    }

    private void setupListener() {
        this.fiName.addKeyListener(new KeyAdapter(){

            @Override
            public void keyReleased(KeyEvent e) {
                if (e.getKeyCode() == 27) {
                    ModalScene.this.dispose();
                }
                ModalScene.this.btnAdd.setEnabled(ModalScene.this.fiName.getText().length() > 0);
            }
        });
        this.btnAdd.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                String name = ModalScene.this.fiName.getText();
                if (!SceneEditor.seScenes.containsKey(name)) {
                    new ActionAddScene(ModalScene.this.fiName.getText()).actionPerformed(e);
                    ModalScene.this.dispose();
                } else {
                    JOptionPane.showMessageDialog(ModalScene.this, "A scene with that name already exists");
                }
            }
        });
        this.fiName.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ModalScene.this.btnAdd.doClick();
            }
        });
    }
}

