/*
 * Decompiled with CFR 0.152.
 */
package ch.sparkpudding.sceneeditor.panel.modal;

import ch.sparkpudding.coreengine.ecs.entity.Entity;
import ch.sparkpudding.sceneeditor.SceneEditor;
import ch.sparkpudding.sceneeditor.action.ActionSetEntityTemplate;
import ch.sparkpudding.sceneeditor.panel.modal.Modal;
import java.awt.FlowLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JTextField;

public class ModalEntityTemplate
extends Modal {
    private JLabel lblName;
    private JTextField templateName;
    private JButton btnAdd;
    private Entity entity;

    public ModalEntityTemplate(Entity entity) {
        super(SceneEditor.frameSceneEditor, "Save as template", (Boolean)true);
        this.entity = entity;
        this.init();
        this.setupLayout();
        this.setupListener();
        this.setupFrame();
    }

    private void init() {
        this.lblName = new JLabel("Name :");
        this.templateName = new JTextField(15);
        this.templateName.setText(this.entity.getTemplate());
        this.templateName.selectAll();
        this.btnAdd = new JButton("Override \"" + this.entity.getTemplate() + "\"");
    }

    private void setupLayout() {
        this.mainPanel.setLayout(new FlowLayout(1));
        this.mainPanel.add(this.lblName);
        this.mainPanel.add(this.templateName);
        this.mainPanel.add(this.btnAdd);
    }

    private void setupFrame() {
        this.pack();
        this.setResizable(false);
        this.setLocationRelativeTo(null);
        this.setVisible(true);
    }

    private void setupListener() {
        this.templateName.addKeyListener(new KeyAdapter(){

            @Override
            public void keyReleased(KeyEvent e) {
                if (Entity.getTemplates().get(ModalEntityTemplate.this.templateName.getText()) == null) {
                    ModalEntityTemplate.this.btnAdd.setText("Create template");
                } else {
                    ModalEntityTemplate.this.btnAdd.setText("Override \"" + ModalEntityTemplate.this.entity.getTemplate() + "\"");
                }
                ModalEntityTemplate.this.btnAdd.setEnabled(ModalEntityTemplate.this.templateName.getText().length() > 0);
            }
        });
        this.btnAdd.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                String name = ModalEntityTemplate.this.templateName.getText();
                new ActionSetEntityTemplate(ModalEntityTemplate.this.entity, name).actionPerformed(e);
                ModalEntityTemplate.this.dispose();
            }
        });
        this.templateName.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ModalEntityTemplate.this.btnAdd.doClick();
            }
        });
    }
}

