/*
 * Decompiled with CFR 0.152.
 */
package ch.sparkpudding.sceneeditor.panel.modal;

import ch.sparkpudding.coreengine.ecs.entity.Entity;
import ch.sparkpudding.sceneeditor.SceneEditor;
import ch.sparkpudding.sceneeditor.action.ActionAddEntity;
import ch.sparkpudding.sceneeditor.panel.modal.Modal;
import java.awt.FlowLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JTextField;

public class ModalEntity
extends Modal {
    private JLabel labelName;
    private JTextField textFieldName;
    private JLabel labelTemplate;
    private JComboBox<String> comboBoxTemplate;
    private JButton buttonAdd;
    private JButton buttonCancel;

    public ModalEntity() {
        super(SceneEditor.frameSceneEditor, "New entity", (Boolean)true);
        this.init();
        this.setupLayout();
        this.setupListener();
        this.setupFrame();
    }

    private void init() {
        this.labelName = new JLabel("Name :");
        this.textFieldName = new JTextField(15);
        this.labelTemplate = new JLabel("Template :");
        this.comboBoxTemplate = new JComboBox();
        this.buttonCancel = new JButton("Cancel");
        this.buttonAdd = new JButton("Add");
        this.buttonAdd.setEnabled(false);
        this.populateComboBox();
    }

    private void setupLayout() {
        this.mainPanel.setLayout(new FlowLayout(1));
        this.mainPanel.add(this.labelName);
        this.mainPanel.add(this.textFieldName);
        this.mainPanel.add(this.labelTemplate);
        this.mainPanel.add(this.comboBoxTemplate);
        this.mainPanel.add(this.buttonAdd);
        this.mainPanel.add(this.buttonCancel);
    }

    private void setupFrame() {
        this.pack();
        this.setResizable(false);
        this.setLocationRelativeTo(null);
        this.setVisible(true);
    }

    private void setupListener() {
        this.textFieldName.addKeyListener(new KeyAdapter(){

            @Override
            public void keyReleased(KeyEvent e) {
                if (e.getKeyCode() == 27) {
                    ModalEntity.this.dispose();
                }
                ModalEntity.this.buttonAdd.setEnabled(ModalEntity.this.textFieldName.getText().length() > 0);
            }
        });
        this.buttonAdd.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                String name = ModalEntity.this.textFieldName.getText();
                String template = ModalEntity.this.comboBoxTemplate.getSelectedItem().toString();
                new ActionAddEntity(name, template).actionPerformed(e);
                ModalEntity.this.dispose();
            }
        });
        this.buttonCancel.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ModalEntity.this.dispose();
            }
        });
        this.textFieldName.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ModalEntity.this.buttonAdd.doClick();
            }
        });
    }

    private void populateComboBox() {
        for (String nameTemplate : Entity.getTemplates().keySet()) {
            this.comboBoxTemplate.addItem(nameTemplate);
        }
    }
}

