/*
 * Decompiled with CFR 0.152.
 */
package ch.sparkpudding.sceneeditor.panel.modal;

import ch.sparkpudding.coreengine.ecs.component.Field;
import ch.sparkpudding.coreengine.ecs.entity.Entity;
import ch.sparkpudding.sceneeditor.SceneEditor;
import ch.sparkpudding.sceneeditor.action.ActionAddComponent;
import ch.sparkpudding.sceneeditor.ecs.SEEntity;
import ch.sparkpudding.sceneeditor.panel.modal.Modal;
import ch.sparkpudding.sceneeditor.utils.ImageStorage;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.KeyboardFocusManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.util.HashMap;
import java.util.Map;
import javax.swing.AbstractAction;
import javax.swing.ActionMap;
import javax.swing.DefaultCellEditor;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.TableColumn;

public class ModalComponent
extends Modal {
    private JLabel labelComponentName;
    private JComboBox<String> cmbComponents;
    private JTextField fieldComponentName;
    private JComboBox<Field.FieldType> comboBoxFieldType;
    private JTable tableFields;
    private DefaultTableModel tableModel;
    private JPanel panelFields;
    private JScrollPane panelFieldsScroll;
    private JButton buttonValidate;
    private JButton buttonAddField;
    private JButton buttonRemoveField;
    private Entity entity;
    private SEEntity seEntity;

    public ModalComponent(SEEntity seEntity, Entity entity) {
        super(SceneEditor.frameSceneEditor, "Add component", (Boolean)true);
        this.entity = entity;
        this.seEntity = seEntity;
        if (this.init()) {
            this.setupLayout();
            this.setupFieldsTable();
            this.setupFrame();
            this.addListener();
            this.pack();
            this.setLocationRelativeTo(null);
            this.setVisible(true);
        }
    }

    private boolean init() {
        this.labelComponentName = new JLabel("Name :");
        this.fieldComponentName = new JTextField(20);
        this.panelFields = new JPanel();
        this.panelFieldsScroll = new JScrollPane();
        this.buttonValidate = new JButton("OK");
        this.comboBoxFieldType = new JComboBox();
        this.cmbComponents = new JComboBox();
        this.buttonAddField = new JButton(ImageStorage.PLUS);
        this.buttonAddField.setBorderPainted(false);
        this.buttonAddField.setContentAreaFilled(false);
        this.buttonRemoveField = new JButton(ImageStorage.TRASH);
        this.buttonRemoveField.setBorderPainted(false);
        this.buttonRemoveField.setContentAreaFilled(false);
        this.comboBoxFieldType.addItem(Field.FieldType.BOOLEAN);
        this.comboBoxFieldType.addItem(Field.FieldType.DOUBLE);
        this.comboBoxFieldType.addItem(Field.FieldType.FILE_PATH);
        this.comboBoxFieldType.addItem(Field.FieldType.INTEGER);
        this.comboBoxFieldType.addItem(Field.FieldType.STRING);
        Object[] tableHeaders = new String[]{"Name", "Type", "Default value"};
        this.tableModel = new DefaultTableModel(tableHeaders, 3){

            @Override
            public boolean isCellEditable(int row, int column) {
                return column != 0 && column != 1 || ModalComponent.this.entity == null;
            }
        };
        this.tableFields = new JTable(this.tableModel);
        TableColumn cm = this.tableFields.getColumnModel().getColumn(1);
        cm.setCellEditor(new DefaultCellEditor(this.comboBoxFieldType));
        ActionMap am = this.tableFields.getActionMap();
        am.put("selectPreviousColumnCell", new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                KeyboardFocusManager manager = KeyboardFocusManager.getCurrentKeyboardFocusManager();
                manager.focusPreviousComponent();
            }
        });
        am.put("selectNextColumnCell", new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                KeyboardFocusManager manager = KeyboardFocusManager.getCurrentKeyboardFocusManager();
                manager.focusNextComponent();
            }
        });
        for (Map.Entry<String, ch.sparkpudding.coreengine.ecs.component.Component> component : ch.sparkpudding.coreengine.ecs.component.Component.getTemplates().entrySet()) {
            if (component.getValue().getName().startsWith("se-") || this.entity != null && this.entity.hasComponent(component.getValue().getName())) continue;
            this.cmbComponents.addItem(component.getValue().getName());
        }
        if (this.cmbComponents.getItemCount() == 0) {
            JOptionPane.showMessageDialog(this, "This entity already has all existing components.");
            this.dispose();
            return false;
        }
        if (this.entity != null) {
            this.cmbComponents.setSelectedIndex(0);
            this.displayFieldsForComponent(this.cmbComponents.getItemAt(0));
        }
        return true;
    }

    private void setupFieldsTable() {
        this.panelFields.add((Component)this.tableFields.getTableHeader(), "First");
        this.panelFieldsScroll.add(this.tableFields);
        this.panelFieldsScroll.setViewportView(this.tableFields);
        this.panelFieldsScroll.setPreferredSize(new Dimension(250, 150));
        this.panelFields.add((Component)this.panelFieldsScroll, "Center");
    }

    private void setupLayout() {
        this.mainPanel.setLayout(new GridBagLayout());
        GridBagConstraints c = new GridBagConstraints();
        c.fill = 2;
        c.anchor = 10;
        c.gridwidth = 1;
        c.gridheight = 1;
        c.gridx = 0;
        c.gridy = 0;
        c.insets = new Insets(0, 0, 0, 20);
        this.mainPanel.add((Component)this.labelComponentName, c);
        c.gridwidth = 1;
        c.gridx = 1;
        if (this.entity == null) {
            this.mainPanel.add((Component)this.fieldComponentName, c);
            this.panelFields.setLayout(new BorderLayout());
            this.panelFields.add((Component)this.tableFields.getTableHeader(), "First");
            this.panelFields.add((Component)this.tableFields, "Center");
            c.gridx = 0;
            c.gridy = 1;
            c.gridwidth = 3;
            c.insets = new Insets(20, 0, 0, 0);
            this.mainPanel.add((Component)this.panelFields, c);
            c.gridy = 2;
            c.gridx = 1;
            c.gridwidth = 1;
            c.fill = 0;
            c.anchor = 13;
            c.insets = new Insets(5, 0, 0, 0);
            this.mainPanel.add((Component)this.buttonRemoveField, c);
            c.gridx = 2;
            this.mainPanel.add((Component)this.buttonAddField, c);
        } else {
            this.mainPanel.add(this.cmbComponents);
            this.buttonAddField.setEnabled(false);
            this.buttonRemoveField.setEnabled(false);
        }
        c.insets = new Insets(20, 0, 0, 0);
        c.fill = 2;
        c.gridx = 0;
        c.gridy = 3;
        c.gridwidth = 3;
        this.mainPanel.add((Component)this.buttonValidate, c);
    }

    private void setupFrame() {
        this.setSize(300, 500);
        this.setResizable(false);
    }

    private void addListener() {
        this.buttonRemoveField.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                int selectedRow = ModalComponent.this.tableFields.getSelectedRow();
                if (ModalComponent.this.tableModel.getRowCount() > 0) {
                    if (selectedRow == -1) {
                        ModalComponent.this.tableModel.removeRow(ModalComponent.this.tableModel.getRowCount() - 1);
                    } else {
                        ModalComponent.this.tableModel.removeRow(selectedRow);
                    }
                }
                ModalComponent.this.pack();
            }
        });
        this.buttonAddField.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Object[] emptyRow = new String[]{"", "", ""};
                ModalComponent.this.tableModel.addRow(emptyRow);
                ModalComponent.this.pack();
            }
        });
        this.buttonValidate.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                String compName = ModalComponent.this.entity == null ? ModalComponent.this.fieldComponentName.getText() : (String)ModalComponent.this.cmbComponents.getSelectedItem();
                if (!compName.equals("")) {
                    HashMap<String, Field> fields = new HashMap<String, Field>();
                    int i = 0;
                    while (i < ModalComponent.this.tableFields.getRowCount()) {
                        try {
                            String fieldName = (String)ModalComponent.this.tableFields.getModel().getValueAt(i, 0);
                            String fieldType = ModalComponent.this.tableFields.getModel().getValueAt(i, 1) instanceof Field.FieldType ? ((Field.FieldType)((Object)ModalComponent.this.tableFields.getModel().getValueAt(i, 1))).name() : (String)ModalComponent.this.tableFields.getModel().getValueAt(i, 1);
                            String fieldValue = (String)ModalComponent.this.tableFields.getModel().getValueAt(i, 2);
                            if (fieldType != null && fieldName != null) {
                                if (fieldValue == null) {
                                    fieldValue = fieldType.equals("STRING") || fieldType.equals("FILE_PATH") ? "" : "0";
                                }
                                fields.put(fieldName, new Field(fieldName, fieldType, fieldValue));
                            }
                        }
                        catch (Exception exception) {
                            JOptionPane.showMessageDialog(ModalComponent.this, "Please check your inputs.");
                            return;
                        }
                        ++i;
                    }
                    ch.sparkpudding.coreengine.ecs.component.Component component = new ch.sparkpudding.coreengine.ecs.component.Component(compName, fields);
                    if (ModalComponent.this.entity == null) {
                        ch.sparkpudding.coreengine.ecs.component.Component.addTemplate(component);
                    } else {
                        new ActionAddComponent(ModalComponent.this.seEntity, ModalComponent.this.entity, component).actionPerformed(null);
                    }
                    ModalComponent.this.dispose();
                } else {
                    ModalComponent.this.fieldComponentName.setBackground(Color.RED);
                }
            }
        });
        this.cmbComponents.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                ModalComponent.this.displayFieldsForComponent(ModalComponent.this.cmbComponents.getSelectedItem().toString());
            }
        });
        this.cmbComponents.addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent e) {
                if (e.getKeyCode() == 10) {
                    ModalComponent.this.buttonValidate.doClick();
                }
            }
        });
    }

    private void displayFieldsForComponent(String componentName) {
        this.tableModel.setRowCount(0);
        for (Map.Entry<String, ch.sparkpudding.coreengine.ecs.component.Component> component : ch.sparkpudding.coreengine.ecs.component.Component.getTemplates().entrySet()) {
            if (!component.getValue().getName().equals(componentName)) continue;
            for (Map.Entry<String, Field> field : component.getValue().getFields().entrySet()) {
                Object[] row = new String[]{field.getValue().getName(), field.getValue().getType().toString(), field.getValue().getValue().toString()};
                this.tableModel.addRow(row);
            }
        }
        this.pack();
    }
}

