/*
 * Decompiled with CFR 0.152.
 */
package ch.sparkpudding.sceneeditor.panel;

import ch.sparkpudding.coreengine.Scheduler;
import ch.sparkpudding.sceneeditor.SceneEditor;
import ch.sparkpudding.sceneeditor.listener.GameStateEventListener;
import ch.sparkpudding.sceneeditor.utils.ImageStorage;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JPanel;
import javax.swing.border.EmptyBorder;
import javax.swing.border.EtchedBorder;

public class PanelSidebarLeft
extends JPanel {
    private JButton btnPausePlay;
    private JButton btnStop;
    private JButton btnReset;
    private BoxLayout layout;

    public PanelSidebarLeft() {
        this.init();
        this.setupLayout();
        this.addListener();
    }

    private void init() {
        this.layout = new BoxLayout(this, 1);
        this.btnPausePlay = new JButton();
        this.btnStop = new JButton();
        this.btnReset = new JButton();
        this.btnPausePlay.setIcon(ImageStorage.PLAY);
        this.btnStop.setIcon(ImageStorage.STOP_DISABLED);
        this.btnReset.setIcon(ImageStorage.RELOAD);
        this.btnStop.setEnabled(false);
        this.btnPausePlay.setOpaque(false);
        this.btnPausePlay.setContentAreaFilled(false);
        this.btnPausePlay.setBorderPainted(false);
        this.btnStop.setOpaque(false);
        this.btnStop.setContentAreaFilled(false);
        this.btnStop.setBorderPainted(false);
        this.btnReset.setContentAreaFilled(false);
        this.btnReset.setBorderPainted(false);
        this.btnReset.setOpaque(false);
    }

    private void setupLayout() {
        this.setLayout(this.layout);
        this.add(this.btnPausePlay);
        this.add(this.btnStop);
        this.add(this.btnReset);
        this.setBorder(BorderFactory.createCompoundBorder(new EtchedBorder(), new EmptyBorder(10, 10, 10, 10)));
    }

    private void addListener() {
        this.btnPausePlay.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                SceneEditor.coreEngine.getScheduler().schedule(Scheduler.Trigger.GAME_LOOP_START, new Runnable(){

                    @Override
                    public void run() {
                        switch (SceneEditor.getGameState()) {
                            case PLAY: {
                                SceneEditor.setGameState(SceneEditor.EditorState.PAUSE);
                                break;
                            }
                            case ERROR: {
                                SceneEditor.coreEngine.clearError();
                                SceneEditor.setGameState(SceneEditor.EditorState.PAUSE);
                                break;
                            }
                            default: {
                                SceneEditor.setGameState(SceneEditor.EditorState.PLAY);
                            }
                        }
                    }
                });
                SceneEditor.coreEngine.requestFocus();
            }
        });
        this.btnStop.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                SceneEditor.coreEngine.getScheduler().schedule(Scheduler.Trigger.GAME_LOOP_START, new Runnable(){

                    @Override
                    public void run() {
                        SceneEditor.setGameState(SceneEditor.EditorState.STOP);
                    }
                });
                SceneEditor.coreEngine.requestFocus();
            }
        });
        this.btnReset.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                SceneEditor.coreEngine.getScheduler().schedule(Scheduler.Trigger.GAME_LOOP_START, new Runnable(){

                    @Override
                    public void run() {
                        SceneEditor.coreEngine.reloadSystemsFromDisk();
                        if (SceneEditor.coreEngine.isInError()) {
                            SceneEditor.setGameState(SceneEditor.EditorState.PLAY);
                            SceneEditor.coreEngine.clearError();
                        }
                    }
                });
            }
        });
        SceneEditor.addGameStateEventListener(new GameStateEventListener(){

            @Override
            public void gameStateChanged(SceneEditor.EditorState state) {
                switch (state) {
                    case PAUSE: {
                        PanelSidebarLeft.this.btnStop.setIcon(ImageStorage.STOP);
                        PanelSidebarLeft.this.btnPausePlay.setIcon(ImageStorage.PLAY);
                        break;
                    }
                    case PLAY: {
                        PanelSidebarLeft.this.btnStop.setIcon(ImageStorage.STOP);
                        PanelSidebarLeft.this.btnPausePlay.setIcon(ImageStorage.PAUSE);
                        PanelSidebarLeft.this.btnStop.setEnabled(true);
                        break;
                    }
                    case STOP: {
                        PanelSidebarLeft.this.btnStop.setIcon(ImageStorage.STOP_DISABLED);
                        PanelSidebarLeft.this.btnPausePlay.setIcon(ImageStorage.PLAY);
                        PanelSidebarLeft.this.btnStop.setEnabled(false);
                        break;
                    }
                    case ERROR: {
                        PanelSidebarLeft.this.btnPausePlay.setIcon(ImageStorage.WARNING);
                        PanelSidebarLeft.this.btnStop.setIcon(ImageStorage.STOP);
                        PanelSidebarLeft.this.btnStop.setEnabled(true);
                        break;
                    }
                }
            }
        });
    }
}

