/*
 * Decompiled with CFR 0.152.
 */
package ch.sparkpudding.sceneeditor.panel;

import ch.sparkpudding.coreengine.Scheduler;
import ch.sparkpudding.coreengine.ecs.entity.Entity;
import ch.sparkpudding.coreengine.ecs.entity.Scene;
import ch.sparkpudding.coreengine.utils.Pair;
import ch.sparkpudding.coreengine.utils.RunnableOneParameter;
import ch.sparkpudding.sceneeditor.SceneEditor;
import ch.sparkpudding.sceneeditor.action.ActionRemoveScene;
import ch.sparkpudding.sceneeditor.action.ActionRenameScene;
import ch.sparkpudding.sceneeditor.action.ActionTransformEntity;
import ch.sparkpudding.sceneeditor.ecs.SEScene;
import ch.sparkpudding.sceneeditor.listener.EntityEventAdapter;
import ch.sparkpudding.sceneeditor.panel.PanelEntityTree;
import ch.sparkpudding.sceneeditor.panel.modal.ModalScene;
import ch.sparkpudding.sceneeditor.utils.ImageStorage;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.Map;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;

public class PanelScene
extends JPanel {
    private PanelEntityTree panelEntityTree;
    private JComboBox<String> comboBoxScenes;
    private JButton buttonRemoveScene;
    private JButton buttonAddScene;
    private JPanel panelButtons;
    private Rectangle transformStartRectangle;
    private static final String TITLE = "Scenes";

    public PanelScene(PanelEntityTree panelEntityTree) {
        this.panelEntityTree = panelEntityTree;
        this.init();
        this.setupLayout();
        this.addListener();
    }

    private void init() {
        this.comboBoxScenes = new JComboBox();
        this.panelButtons = new JPanel();
        this.buttonAddScene = new JButton(ImageStorage.PLUS);
        this.buttonAddScene.setBorderPainted(false);
        this.buttonAddScene.setContentAreaFilled(false);
        this.buttonRemoveScene = new JButton(ImageStorage.TRASH);
        this.buttonRemoveScene.setBorderPainted(false);
        this.buttonRemoveScene.setContentAreaFilled(false);
        this.buttonRemoveScene.setPreferredSize(this.buttonAddScene.getPreferredSize());
        this.comboBoxScenes.setEditable(true);
    }

    private void setupLayout() {
        this.setLayout(new BorderLayout());
        this.comboBoxScenes.setPreferredSize(new Dimension(275, this.comboBoxScenes.getPreferredSize().height));
        this.comboBoxScenes.setMaximumSize(new Dimension(275, this.comboBoxScenes.getPreferredSize().height));
        this.panelButtons.setLayout(new FlowLayout(2));
        this.panelButtons.add(this.buttonRemoveScene);
        this.panelButtons.add(this.buttonAddScene);
        this.add(this.comboBoxScenes, "Center");
        this.add((Component)this.panelButtons, "East");
        this.setBorder(BorderFactory.createTitledBorder(TITLE));
    }

    private void addListener() {
        SceneEditor.coreEngine.getScheduler().notify(Scheduler.Trigger.SCENE_CHANGED, new RunnableOneParameter(){

            @Override
            public void run() {
                if (SceneEditor.currentScene != null) {
                    SwingUtilities.invokeLater(new Runnable(){

                        @Override
                        public void run() {
                            PanelScene.this.comboBoxScenes.setSelectedItem(((Scene)this.getObject()).getName());
                        }
                    });
                }
            }
        });
        SceneEditor.coreEngine.getScheduler().notify(Scheduler.Trigger.SCENE_LIST_CHANGED, new Runnable(){

            @Override
            public void run() {
                SceneEditor.updateSeSceneList();
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        PanelScene.this.populateComboBox(SceneEditor.seScenes);
                    }
                });
            }
        });
        SceneEditor.coreEngine.getScheduler().notify(Scheduler.Trigger.COMPONENT_ADDED, new RunnableOneParameter(){

            @Override
            public void run() {
                ch.sparkpudding.coreengine.ecs.component.Component component = (ch.sparkpudding.coreengine.ecs.component.Component)((Pair)this.getObject()).second();
                Entity entity = (Entity)((Pair)this.getObject()).first();
                if (component.getName().equals("se-entity-transform-start")) {
                    PanelScene.this.transformStartRectangle = new Rectangle(entity.getComponents().get("position").getField("x").getInt(), entity.getComponents().get("position").getField("y").getInt(), entity.getComponents().get("size").getField("width").getInt(), entity.getComponents().get("size").getField("height").getInt());
                } else if (component.getName().equals("se-entity-transform-done")) {
                    new ActionTransformEntity(entity, PanelScene.this.transformStartRectangle, new Rectangle(entity.getComponents().get("position").getField("x").getInt(), entity.getComponents().get("position").getField("y").getInt(), entity.getComponents().get("size").getField("width").getInt(), entity.getComponents().get("size").getField("height").getInt())).actionPerformed(null);
                }
            }
        });
        SceneEditor.addEntityEventListener(new EntityEventAdapter(){

            @Override
            public void entityListChanged(Map<String, SEScene> seScenes) {
                SceneEditor.updateSeSceneList();
                PanelScene.this.populateComboBox(seScenes);
            }
        });
        this.comboBoxScenes.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                if (e.getStateChange() == 1) {
                    String selected = (String)PanelScene.this.comboBoxScenes.getSelectedItem();
                    boolean alterable = !selected.equals("main");
                    PanelScene.this.comboBoxScenes.setEditable(alterable);
                    PanelScene.this.buttonRemoveScene.setEnabled(alterable);
                    SEScene newScene = SceneEditor.seScenes.get(selected);
                    if (newScene != null) {
                        if (newScene != SceneEditor.currentScene) {
                            PanelScene.this.panelEntityTree.clearSelectedEntity();
                        }
                        SceneEditor.setCurrentScene(newScene);
                        SceneEditor.coreEngine.setCurrentScene(newScene.getLiveScene(), SceneEditor.getGameState() == SceneEditor.EditorState.STOP);
                        PanelScene.this.panelEntityTree.updateListEntities(newScene);
                    } else {
                        new ActionRenameScene(SceneEditor.currentScene.getLiveScene().getName(), selected).actionPerformed(null);
                    }
                }
            }
        });
        this.buttonAddScene.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                new ModalScene();
            }
        });
        this.buttonRemoveScene.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                String toRemove = (String)PanelScene.this.comboBoxScenes.getSelectedItem();
                PanelScene.this.comboBoxScenes.setSelectedItem("main");
                new ActionRemoveScene(toRemove).actionPerformed(null);
            }
        });
    }

    private void populateComboBox(Map<String, SEScene> seScenes) {
        Scene lastScene = SceneEditor.coreEngine.getCurrentScene();
        this.comboBoxScenes.removeAllItems();
        for (SEScene scene : seScenes.values()) {
            this.comboBoxScenes.addItem(scene.getLiveScene().getName());
        }
        this.comboBoxScenes.setSelectedItem(lastScene.getName());
    }
}

