/*
 * Decompiled with CFR 0.152.
 */
package ch.sparkpudding.sceneeditor.panel;

import ch.sparkpudding.coreengine.Scheduler;
import ch.sparkpudding.coreengine.ecs.component.Component;
import ch.sparkpudding.coreengine.ecs.component.Field;
import ch.sparkpudding.coreengine.utils.RunnableOneParameter;
import ch.sparkpudding.sceneeditor.SceneEditor;
import ch.sparkpudding.sceneeditor.action.ActionChangeCheckBox;
import ch.sparkpudding.sceneeditor.action.ActionChangeTextField;
import ch.sparkpudding.sceneeditor.utils.SpringUtilities;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.text.NumberFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JFormattedTextField;
import javax.swing.JLabel;
import javax.swing.JTextField;
import javax.swing.SpringLayout;
import javax.swing.SwingUtilities;
import javax.swing.text.JTextComponent;

public class PanelFieldsEditor
extends JComponent {
    private Collection<Field> fields;
    private List<RunnableOneParameter> onFieldsChanged;
    private List<JComponent> fieldsInput;
    private Component component;
    private boolean enableable;

    public PanelFieldsEditor(Component component, boolean enableable) {
        this.fields = new ArrayList<Field>(component.getFields().values());
        this.fieldsInput = new ArrayList<JComponent>();
        this.onFieldsChanged = new ArrayList<RunnableOneParameter>();
        this.enableable = enableable;
        this.component = component;
        this.createFields();
        this.setupLayout();
    }

    private void setupLayout() {
        this.setLayout(new SpringLayout());
        if (this.fields.size() > 0) {
            SpringUtilities.makeGrid(this, this.fields.size(), 2, 5, 5, 5, 5);
        }
    }

    private void createFields() {
        ArrayList<Field> sortedFields = new ArrayList<Field>(this.fields);
        sortedFields.sort(new Comparator<Field>(){

            @Override
            public int compare(Field arg0, Field arg1) {
                return arg0.getName().compareTo(arg1.getName());
            }
        });
        for (Field field : sortedFields) {
            JLabel labelField = new JLabel(field.getName());
            this.add(labelField);
            JComponent valueField = this.createValueField(field, labelField);
            this.add(valueField);
        }
    }

    @Override
    public void removeNotify() {
        for (RunnableOneParameter onFieldChanged : this.onFieldsChanged) {
            SceneEditor.coreEngine.getScheduler().removeNotify(Scheduler.Trigger.GAME_LOOP_START, onFieldChanged);
        }
        super.removeNotify();
    }

    private JComponent createValueField(Field field, JLabel labelField) {
        JComponent input;
        switch (field.getType()) {
            case INTEGER: {
                NumberFormat integerFormatter = NumberFormat.getIntegerInstance();
                integerFormatter.setGroupingUsed(false);
                input = new JFormattedTextField(integerFormatter);
                ((JFormattedTextField)input).setValue(field.getInt());
                this.addTextFieldListener((JTextField)input, field);
                break;
            }
            case DOUBLE: {
                input = new JFormattedTextField(NumberFormat.getInstance());
                ((JFormattedTextField)input).setValue(field.getDouble());
                this.addTextFieldListener((JTextField)input, field);
                break;
            }
            default: {
                input = new JTextField();
                ((JTextComponent)input).setText(field.getValue().toString());
                this.addTextFieldListener((JTextField)input, field);
                break;
            }
            case FILE_PATH: {
                input = new JFormattedTextField();
                ((JFormattedTextField)input).setValue(field.getValue());
                this.addTextFieldListener((JTextField)input, field);
                break;
            }
            case BOOLEAN: {
                input = new JCheckBox("", (boolean)((Boolean)field.getValue()));
                this.addCheckBoxListener((JCheckBox)input, field);
            }
        }
        labelField.setLabelFor(input);
        input.setEnabled(this.enableable);
        this.fieldsInput.add(input);
        return input;
    }

    private void addTextFieldListener(final JTextField input, final Field field) {
        RunnableOneParameter onFieldChange = new RunnableOneParameter(){

            @Override
            public void run() {
                try {
                    if (!field.getValue().toString().equals(input.getText()) && !input.hasFocus()) {
                        SwingUtilities.invokeLater(new Runnable(){

                            @Override
                            public void run() {
                                input.setText(field.getValue().toString());
                            }
                        });
                    }
                }
                catch (Exception e) {
                    System.err.println("Known issue");
                    e.printStackTrace();
                }
            }
        };
        this.onFieldsChanged.add(onFieldChange);
        SceneEditor.coreEngine.getScheduler().notify(Scheduler.Trigger.GAME_LOOP_START, onFieldChange);
        input.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ActionChangeTextField action = new ActionChangeTextField(field, input, PanelFieldsEditor.this.component.getName());
                action.actionPerformed(e);
            }
        });
        input.addFocusListener(new FocusAdapter(){

            @Override
            public void focusGained(FocusEvent e) {
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        input.selectAll();
                    }
                });
            }

            @Override
            public void focusLost(FocusEvent e) {
                ActionChangeTextField action = new ActionChangeTextField(field, input, PanelFieldsEditor.this.component.getName());
                action.actionPerformed(null);
            }
        });
    }

    private void addCheckBoxListener(final JCheckBox input, final Field field) {
        RunnableOneParameter onFieldChange = new RunnableOneParameter(){

            @Override
            public void run() {
                try {
                    if (input.isSelected() != ((Boolean)field.getValue()).booleanValue() && !input.hasFocus()) {
                        SwingUtilities.invokeLater(new Runnable(){

                            @Override
                            public void run() {
                                input.setSelected((Boolean)field.getValue());
                            }
                        });
                    }
                }
                catch (Exception e) {
                    System.err.println("Known issue.");
                    e.printStackTrace();
                }
            }
        };
        this.onFieldsChanged.add(onFieldChange);
        SceneEditor.coreEngine.getScheduler().notify(Scheduler.Trigger.GAME_LOOP_START, onFieldChange);
        input.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ActionChangeCheckBox action = new ActionChangeCheckBox("", field, input);
                action.actionPerformed(e);
            }
        });
    }

    @Override
    public void setEnabled(boolean enabled) {
        if (this.enableable) {
            for (JComponent comp : this.fieldsInput) {
                comp.setEnabled(enabled);
            }
        }
        super.setEnabled(enabled);
    }
}

