/*
 * Decompiled with CFR 0.152.
 */
package ch.sparkpudding.sceneeditor.panel;

import ch.sparkpudding.coreengine.Scheduler;
import ch.sparkpudding.coreengine.ecs.entity.Entity;
import ch.sparkpudding.coreengine.utils.Pair;
import ch.sparkpudding.coreengine.utils.RunnableOneParameter;
import ch.sparkpudding.sceneeditor.SceneEditor;
import ch.sparkpudding.sceneeditor.action.ActionRemoveEntity;
import ch.sparkpudding.sceneeditor.ecs.SEEntity;
import ch.sparkpudding.sceneeditor.ecs.SEScene;
import ch.sparkpudding.sceneeditor.listener.EntityEventAdapter;
import ch.sparkpudding.sceneeditor.panel.PanelEntity;
import ch.sparkpudding.sceneeditor.panel.modal.ModalEntity;
import ch.sparkpudding.sceneeditor.utils.ImageStorage;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.Comparator;
import javax.swing.BorderFactory;
import javax.swing.DefaultListCellRenderer;
import javax.swing.DefaultListModel;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.SwingUtilities;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;

public class PanelEntityTree
extends JPanel {
    private PanelEntity panelEntity;
    private DefaultListModel<SEEntity> listModelEntities;
    private JList<SEEntity> jListEntities;
    private JScrollPane listScroller;
    private JPanel panelButtons;
    private JButton buttonAdd;
    private JButton buttonRemove;
    private boolean canChange;
    private static final String TITLE = "Entity list";

    public PanelEntityTree(PanelEntity panelEntity) {
        this.panelEntity = panelEntity;
        this.canChange = true;
        this.init();
        this.setupLayout();
        this.addListener();
    }

    private void init() {
        this.listModelEntities = new DefaultListModel();
        this.jListEntities = new JList<SEEntity>(this.listModelEntities);
        this.jListEntities.setSelectionMode(0);
        this.jListEntities.setLayoutOrientation(0);
        this.jListEntities.setVisibleRowCount(-1);
        this.jListEntities.setCellRenderer(new DefaultListCellRenderer(){

            @Override
            public Component getListCellRendererComponent(JList<?> list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
                Component renderer = super.getListCellRendererComponent(list, value, index, isSelected, cellHasFocus);
                if (renderer instanceof JLabel && value instanceof SEEntity) {
                    ((JLabel)renderer).setText(((SEEntity)value).getDefaultEntity().getName());
                }
                return renderer;
            }
        });
        this.listScroller = new JScrollPane(this.jListEntities);
        this.panelButtons = new JPanel();
        this.buttonAdd = new JButton(ImageStorage.PLUS);
        this.buttonAdd.setBorderPainted(false);
        this.buttonAdd.setContentAreaFilled(false);
        this.buttonRemove = new JButton(ImageStorage.TRASH);
        this.buttonRemove.setBorderPainted(false);
        this.buttonRemove.setEnabled(false);
        this.buttonRemove.setContentAreaFilled(false);
    }

    private void setupLayout() {
        this.setLayout(new BorderLayout());
        this.listScroller.setPreferredSize(new Dimension(275, 275));
        this.listScroller.setMaximumSize(new Dimension(275, 275));
        this.add((Component)this.listScroller, "Center");
        this.add((Component)this.panelButtons, "South");
        this.panelButtons.setLayout(new FlowLayout(2));
        this.panelButtons.add(this.buttonRemove);
        this.panelButtons.add(this.buttonAdd);
        this.setBorder(BorderFactory.createTitledBorder(TITLE));
    }

    private void addListener() {
        this.jListEntities.addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent e) {
                if (PanelEntityTree.this.jListEntities.getSelectedIndex() != -1) {
                    SceneEditor.setSelectedEntity((SEEntity)PanelEntityTree.this.jListEntities.getSelectedValue());
                }
            }
        });
        SceneEditor.coreEngine.getScheduler().notify(Scheduler.Trigger.COMPONENT_ADDED, new RunnableOneParameter(){

            @Override
            public void run() {
                ch.sparkpudding.coreengine.ecs.component.Component component = (ch.sparkpudding.coreengine.ecs.component.Component)((Pair)this.getObject()).second();
                if (component.getName().equals("se-selected")) {
                    final Entity entity = (Entity)((Pair)this.getObject()).first();
                    for (final SEEntity seEntity : SceneEditor.currentScene.getSEEntities()) {
                        if (seEntity.getLiveEntity() != entity || !PanelEntityTree.this.canChange) continue;
                        if (PanelEntityTree.this.jListEntities.getSelectedValue() == null || ((SEEntity)PanelEntityTree.this.jListEntities.getSelectedValue()).getLiveEntity() != entity) {
                            PanelEntityTree.this.canChange = false;
                            SwingUtilities.invokeLater(new Runnable(){

                                @Override
                                public void run() {
                                    PanelEntityTree.this.canChange = true;
                                    PanelEntityTree.this.selectSEEntity(seEntity);
                                }
                            });
                            return;
                        }
                        return;
                    }
                    if (PanelEntityTree.this.canChange) {
                        SceneEditor.coreEngine.getScheduler().schedule(Scheduler.Trigger.GAME_LOOP_START, new Runnable(){

                            @Override
                            public void run() {
                                SceneEditor.setSelectedEntity(new SEEntity(null, entity));
                            }
                        });
                        SwingUtilities.invokeLater(new Runnable(){

                            @Override
                            public void run() {
                                PanelEntityTree.this.jListEntities.removeSelectionInterval(0, PanelEntityTree.this.jListEntities.getModel().getSize());
                            }
                        });
                    }
                }
            }
        });
        this.buttonAdd.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                new ModalEntity();
            }
        });
        this.buttonRemove.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ActionRemoveEntity action = new ActionRemoveEntity(SceneEditor.selectedEntity, SceneEditor.currentScene.getLiveScene());
                action.actionPerformed(e);
                PanelEntityTree.this.buttonRemove.setEnabled(false);
            }
        });
        SceneEditor.addEntityEventListener(new EntityEventAdapter(){

            @Override
            public void changeSelectedEntity(SEEntity entity) {
                if (entity != null) {
                    PanelEntityTree.this.buttonRemove.setEnabled(true);
                } else {
                    PanelEntityTree.this.buttonRemove.setEnabled(false);
                }
            }
        });
    }

    public void updateListEntities(SEScene scene) {
        SEEntity previousEntity = this.jListEntities.getSelectedValue();
        int previousIndex = this.jListEntities.getSelectedIndex();
        this.listModelEntities.removeAllElements();
        ArrayList<SEEntity> sortedEntities = new ArrayList<SEEntity>();
        for (SEEntity entity : scene.getSEEntities()) {
            sortedEntities.add(entity);
        }
        sortedEntities.sort(new Comparator<SEEntity>(){

            @Override
            public int compare(SEEntity arg0, SEEntity arg1) {
                if (arg0.getLiveEntity().getZIndex() > arg1.getLiveEntity().getZIndex()) {
                    return -1;
                }
                if (arg0.getLiveEntity().getZIndex() < arg1.getLiveEntity().getZIndex()) {
                    return 1;
                }
                return arg0.getLiveEntity().getName().compareTo(arg1.getLiveEntity().getName());
            }
        });
        for (SEEntity entity : sortedEntities) {
            this.listModelEntities.addElement(entity);
        }
        if (previousEntity != null) {
            if (((DefaultListModel)this.jListEntities.getModel()).contains(previousEntity)) {
                this.jListEntities.setSelectedValue(previousEntity, true);
            } else {
                this.jListEntities.setSelectedIndex(previousIndex);
            }
        }
        this.revalidate();
    }

    public void selectSEEntity(SEEntity entity) {
        if (this.jListEntities.getSelectedValue() != entity) {
            this.jListEntities.setSelectedValue(entity, true);
        }
    }

    public void clearSelectedEntity() {
        this.panelEntity.clearTabbedPanes();
    }
}

