/*
 * Decompiled with CFR 0.152.
 */
package ch.sparkpudding.sceneeditor.panel;

import ch.sparkpudding.sceneeditor.SceneEditor;
import ch.sparkpudding.sceneeditor.action.ActionSetZIndex;
import ch.sparkpudding.sceneeditor.ecs.SEEntity;
import ch.sparkpudding.sceneeditor.listener.EntityEventAdapter;
import ch.sparkpudding.sceneeditor.listener.GameStateEventListener;
import ch.sparkpudding.sceneeditor.panel.PanelComponentsContainer;
import ch.sparkpudding.sceneeditor.panel.modal.ModalComponent;
import ch.sparkpudding.sceneeditor.panel.modal.ModalEntityTemplate;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTabbedPane;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public class PanelEntity
extends JPanel {
    private PanelComponentsContainer initialPanelComponent;
    private PanelComponentsContainer livePanelComponent;
    private JTabbedPane jTabbedPane;
    private JButton btnAddComponent;
    private JButton btnSaveAsTemplate;
    private JPanel entitySettings;
    private JTextField entityZIndex;
    private SEEntity currentEntity;
    private static final String TITLE = "Entity";
    private static final String TITLE_LIVE = "Live entity";

    public PanelEntity() {
        this.init();
        this.setupLayout();
        this.addListener();
    }

    private void init() {
        this.entitySettings = new JPanel();
        this.initialPanelComponent = new PanelComponentsContainer();
        this.livePanelComponent = new PanelComponentsContainer();
        this.jTabbedPane = new JTabbedPane();
        this.btnAddComponent = new JButton("Add component");
        this.btnSaveAsTemplate = new JButton("Save as template");
        this.entityZIndex = new JTextField();
    }

    private void setupLayout() {
        this.setLayout(new BorderLayout());
        JPanel bottomButtons = new JPanel();
        bottomButtons.setLayout(new FlowLayout());
        this.entitySettings.setLayout(new BorderLayout(10, 10));
        this.entitySettings.add((Component)new JLabel("Z-Index: "), "West");
        this.entitySettings.add((Component)this.entityZIndex, "Center");
        this.jTabbedPane.addTab("Initial", this.initialPanelComponent);
        this.jTabbedPane.addTab("Live", this.livePanelComponent);
        this.entityZIndex.setEnabled(false);
        this.btnAddComponent.setEnabled(false);
        this.btnSaveAsTemplate.setEnabled(false);
        this.add((Component)this.entitySettings, "North");
        this.add((Component)this.jTabbedPane, "Center");
        bottomButtons.add(this.btnAddComponent);
        bottomButtons.add(this.btnSaveAsTemplate);
        this.add((Component)bottomButtons, "South");
        this.resetBorderTitle();
    }

    private void addListener() {
        SceneEditor.addGameStateEventListener(new GameStateEventListener(){

            @Override
            public void gameStateChanged(SceneEditor.EditorState state) {
                PanelEntity.this.resetEnabledPane();
            }
        });
        SceneEditor.addEntityEventListener(new EntityEventAdapter(){

            @Override
            public void changeSelectedEntity(SEEntity entity) {
                PanelEntity.this.setEntity(entity);
            }
        });
        this.btnAddComponent.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                switch (PanelEntity.this.jTabbedPane.getSelectedIndex()) {
                    case 0: {
                        new ModalComponent(SceneEditor.selectedEntity, SceneEditor.selectedEntity.getDefaultEntity());
                        break;
                    }
                    case 1: {
                        new ModalComponent(SceneEditor.selectedEntity, SceneEditor.selectedEntity.getLiveEntity());
                        break;
                    }
                    default: {
                        System.err.println("Invalid selected panel");
                    }
                }
            }
        });
        this.btnSaveAsTemplate.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                switch (PanelEntity.this.jTabbedPane.getSelectedIndex()) {
                    case 0: {
                        new ModalEntityTemplate(SceneEditor.selectedEntity.getDefaultEntity());
                        break;
                    }
                    case 1: {
                        new ModalEntityTemplate(SceneEditor.selectedEntity.getLiveEntity());
                        break;
                    }
                    default: {
                        System.err.println("Invalid selected panel");
                    }
                }
            }
        });
        this.entityZIndex.addFocusListener(new FocusAdapter(){

            @Override
            public void focusGained(FocusEvent e) {
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        PanelEntity.this.entityZIndex.selectAll();
                    }
                });
            }

            @Override
            public void focusLost(FocusEvent arg0) {
                try {
                    int zIndex = Integer.parseInt(PanelEntity.this.entityZIndex.getText());
                    new ActionSetZIndex(SceneEditor.selectedEntity, zIndex).actionPerformed(null);
                }
                catch (Exception e) {
                    PanelEntity.this.entityZIndex.setText(String.valueOf(SceneEditor.selectedEntity.getLiveEntity().getZIndex()));
                }
            }
        });
        this.entityZIndex.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                try {
                    int zIndex = Integer.parseInt(PanelEntity.this.entityZIndex.getText());
                    new ActionSetZIndex(SceneEditor.selectedEntity, zIndex).actionPerformed(null);
                }
                catch (Exception e) {
                    PanelEntity.this.entityZIndex.setText(String.valueOf(SceneEditor.selectedEntity.getLiveEntity().getZIndex()));
                }
            }
        });
        this.jTabbedPane.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent arg0) {
                boolean enabled = true;
                switch (PanelEntity.this.jTabbedPane.getSelectedIndex()) {
                    case 0: {
                        enabled = SceneEditor.selectedEntity != null && SceneEditor.getGameState() == SceneEditor.EditorState.STOP;
                        break;
                    }
                    case 1: {
                        enabled = SceneEditor.selectedEntity != null && SceneEditor.getGameState() != SceneEditor.EditorState.STOP;
                        break;
                    }
                    default: {
                        System.err.println("Invalid selected panel");
                    }
                }
                PanelEntity.this.btnAddComponent.setEnabled(enabled);
                PanelEntity.this.btnSaveAsTemplate.setEnabled(enabled);
            }
        });
    }

    private void resetBorderTitle() {
        if (this.currentEntity != null) {
            if (this.currentEntity.getDefaultEntity() != null) {
                this.setBorder(BorderFactory.createTitledBorder("Entity \u2014 " + this.currentEntity.getDefaultEntity().getName() + " (" + this.currentEntity.getDefaultEntity().getTemplate() + ")"));
            } else {
                this.setBorder(BorderFactory.createTitledBorder("Live entity \u2014 " + this.currentEntity.getLiveEntity().getName() + " (" + this.currentEntity.getLiveEntity().getTemplate() + ")"));
            }
        } else {
            this.setBorder(BorderFactory.createTitledBorder("Entity \u2014 (none)"));
        }
    }

    private void resetEnabledPane() {
        switch (SceneEditor.getGameState()) {
            case STOP: {
                this.initialPanelComponent.setEnabled(true);
                this.livePanelComponent.setEnabled(false);
                this.jTabbedPane.setEnabledAt(1, false);
                this.jTabbedPane.setSelectedIndex(0);
                break;
            }
            case ERROR: {
                break;
            }
            default: {
                this.initialPanelComponent.setEnabled(false);
                this.livePanelComponent.setEnabled(true);
                this.jTabbedPane.setEnabledAt(1, true);
                this.jTabbedPane.setSelectedIndex(1);
            }
        }
        this.entityZIndex.setEnabled(SceneEditor.selectedEntity != null);
        this.btnAddComponent.setEnabled(SceneEditor.selectedEntity != null);
        this.btnSaveAsTemplate.setEnabled(SceneEditor.selectedEntity != null);
    }

    private void setEntity(SEEntity seEntity) {
        if (seEntity == null) {
            this.clearTabbedPanes();
            return;
        }
        this.currentEntity = seEntity;
        if (seEntity.getDefaultEntity() != null) {
            this.initialPanelComponent.setEntity(seEntity, this.currentEntity.getDefaultEntity());
            this.jTabbedPane.setEnabledAt(0, true);
        } else {
            this.jTabbedPane.setEnabledAt(0, false);
        }
        this.entityZIndex.setText(String.valueOf(seEntity.getLiveEntity().getZIndex()));
        this.livePanelComponent.setEntity(seEntity, this.currentEntity.getLiveEntity());
        this.resetBorderTitle();
        this.resetEnabledPane();
    }

    public void clearTabbedPanes() {
        this.currentEntity = null;
        this.setBorder(BorderFactory.createTitledBorder("Entity \u2014 null"));
        this.initialPanelComponent.removeAll();
        this.initialPanelComponent.invalidate();
        this.initialPanelComponent.repaint();
        this.livePanelComponent.removeAll();
        this.livePanelComponent.invalidate();
        this.livePanelComponent.repaint();
        this.entityZIndex.setEnabled(false);
        this.btnAddComponent.setEnabled(false);
        this.btnSaveAsTemplate.setEnabled(false);
    }
}

