/*
 * Decompiled with CFR 0.152.
 */
package ch.sparkpudding.sceneeditor.panel;

import ch.sparkpudding.coreengine.Scheduler;
import ch.sparkpudding.coreengine.ecs.component.Component;
import ch.sparkpudding.coreengine.ecs.component.Field;
import ch.sparkpudding.coreengine.ecs.system.System;
import ch.sparkpudding.sceneeditor.SceneEditor;
import ch.sparkpudding.sceneeditor.action.ActionRemoveSystem;
import ch.sparkpudding.sceneeditor.listener.SystemEventListener;
import ch.sparkpudding.sceneeditor.panel.modal.ModalSystem;
import ch.sparkpudding.sceneeditor.utils.ButtonTabComponent;
import ch.sparkpudding.sceneeditor.utils.ImageStorage;
import java.awt.BorderLayout;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.stream.Stream;
import javax.swing.DefaultListCellRenderer;
import javax.swing.DefaultListModel;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.ListModel;
import javax.swing.event.CaretEvent;
import javax.swing.event.CaretListener;
import org.fife.ui.autocomplete.AutoCompletion;
import org.fife.ui.autocomplete.BasicCompletion;
import org.fife.ui.autocomplete.CompletionProvider;
import org.fife.ui.autocomplete.DefaultCompletionProvider;
import org.fife.ui.rsyntaxtextarea.FileLocation;
import org.fife.ui.rsyntaxtextarea.TextEditorPane;
import org.fife.ui.rtextarea.RTextScrollPane;

public class PanelEditor
extends JPanel {
    public static final int DEFAULT_PANEL_HEIGHT = 400;
    private JTabbedPane jTabbedPane;
    private ListModel<System> listModel;
    private List<String> nameSystems;
    private JScrollPane listScroller;
    private JList<System> jList;
    private JPanel jPanelList;
    private JPanel jPanelButton;
    private JButton buttonAdd;
    private JButton buttonRemove;

    public PanelEditor() {
        this.init();
        this.setupLayout();
        this.addListener();
    }

    private void init() {
        this.nameSystems = new ArrayList<String>();
        this.jTabbedPane = new JTabbedPane();
        this.jPanelList = new JPanel();
        this.jPanelButton = new JPanel();
        this.listModel = new DefaultListModel<System>();
        this.jList = new JList<System>(this.listModel);
        this.jList.setSelectionMode(0);
        this.jList.setLayoutOrientation(0);
        this.jList.setVisibleRowCount(-1);
        this.jList.setCellRenderer(new DefaultListCellRenderer(){

            @Override
            public java.awt.Component getListCellRendererComponent(JList<?> list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
                java.awt.Component renderer = super.getListCellRendererComponent(list, value, index, isSelected, cellHasFocus);
                if (renderer instanceof JLabel && value instanceof System) {
                    String name = ((System)value).getName();
                    ((JLabel)renderer).setText(name);
                }
                return renderer;
            }
        });
        this.populateSystemList();
        this.listScroller = new JScrollPane(this.jList);
        this.buttonAdd = new JButton(ImageStorage.PLUS);
        this.buttonAdd.setBorderPainted(false);
        this.buttonAdd.setContentAreaFilled(false);
        this.buttonRemove = new JButton(ImageStorage.TRASH);
        this.buttonRemove.setBorderPainted(false);
        this.buttonRemove.setContentAreaFilled(false);
    }

    private void setupLayout() {
        this.setLayout(new BorderLayout());
        this.listScroller.setPreferredSize(new Dimension(275, 275));
        this.listScroller.setMaximumSize(new Dimension(275, 275));
        this.jPanelList.setLayout(new BorderLayout());
        this.jPanelButton.setLayout(new FlowLayout(2));
        this.jPanelButton.add(this.buttonRemove);
        this.jPanelButton.add(this.buttonAdd);
        this.jPanelList.add((java.awt.Component)this.listScroller, "Center");
        this.jPanelList.add((java.awt.Component)this.jPanelButton, "South");
        this.add((java.awt.Component)this.jTabbedPane, "Center");
        this.add((java.awt.Component)this.jPanelList, "East");
    }

    private void addTab(System system) {
        if (this.jTabbedPane.indexOfTab(system.getName()) != -1) {
            this.jTabbedPane.setSelectedIndex(this.jTabbedPane.indexOfTab(system.getName()));
            return;
        }
        try {
            final ButtonTabComponent buttonTabComponent = new ButtonTabComponent(this.jTabbedPane);
            CompletionProvider provider = this.createCompletionProviderForSystem(system);
            AutoCompletion autoCompletion = new AutoCompletion(provider);
            buttonTabComponent.setDirty(false);
            final TextEditorPane editorPane = new TextEditorPane(0, false, FileLocation.create(system.getFilepath()));
            editorPane.setSyntaxEditingStyle("text/lua");
            editorPane.setCodeFoldingEnabled(true);
            editorPane.setText(this.readFile(system.getFilepath()));
            editorPane.setTabSize(2);
            editorPane.convertSpacesToTabs();
            editorPane.addCaretListener(new CaretListener(){

                @Override
                public void caretUpdate(CaretEvent e) {
                    buttonTabComponent.setDirty(editorPane.isDirty());
                }
            });
            editorPane.addKeyListener(new KeyAdapter(){

                @Override
                public void keyPressed(KeyEvent e) {
                    if (e.getKeyCode() == 83 && (e.getModifiersEx() & 0x80) != 0) {
                        try {
                            editorPane.save();
                            buttonTabComponent.setDirty(editorPane.isDirty());
                            SceneEditor.coreEngine.getScheduler().schedule(Scheduler.Trigger.GAME_LOOP_START, new Runnable(){

                                @Override
                                public void run() {
                                    SceneEditor.coreEngine.reloadSystemsFromDisk();
                                    SceneEditor.clearError();
                                }
                            });
                        }
                        catch (IOException e1) {
                            e1.printStackTrace();
                        }
                    }
                }
            });
            autoCompletion.install(editorPane);
            RTextScrollPane sp = new RTextScrollPane(editorPane);
            this.jTabbedPane.addTab(system.getName(), sp);
            this.jTabbedPane.setSelectedIndex(this.jTabbedPane.getTabCount() - 1);
            this.jTabbedPane.setTabComponentAt(this.jTabbedPane.getTabCount() - 1, buttonTabComponent);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private CompletionProvider createCompletionProviderForSystem(System system) {
        DefaultCompletionProvider codeCP = new DefaultCompletionProvider();
        Map<String, List<String>> componentGroups = system.getComponentGroups();
        ArrayList<String> addedComponent = new ArrayList<String>();
        for (String groupName : componentGroups.keySet()) {
            for (String componentName : componentGroups.get(groupName)) {
                if (!addedComponent.contains(componentName)) {
                    try {
                        for (Map.Entry<String, Field> field : Component.getTemplates().get(componentName)) {
                            codeCP.addCompletion(new BasicCompletion(codeCP, String.valueOf(componentName) + "." + field.getKey(), ""));
                        }
                    }
                    catch (Exception e) {
                        JOptionPane.showMessageDialog(this, "System " + system.getName() + " is trying to require the inexisting component " + componentName, "System warning", 2);
                    }
                }
                addedComponent.add(componentName);
            }
        }
        return codeCP;
    }

    private String readFile(String filepath) {
        StringBuilder contentBuilder = new StringBuilder();
        try {
            Throwable throwable = null;
            Object var4_6 = null;
            try (Stream<String> stream = Files.lines(Paths.get(filepath, new String[0]), StandardCharsets.UTF_8);){
                stream.forEach(s -> {
                    StringBuilder stringBuilder2 = contentBuilder.append((String)s).append("\n");
                });
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return contentBuilder.toString();
    }

    private void addListener() {
        SceneEditor.addSystemEventListener(new SystemEventListener(){

            @Override
            public void systemListChanged() {
                PanelEditor.this.populateSystemList();
                PanelEditor.this.findRemovedSystem();
            }
        });
        this.jList.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent mouseEvent) {
                if (mouseEvent.getSource() instanceof JList) {
                    int index;
                    JList list = (JList)mouseEvent.getSource();
                    if (mouseEvent.getClickCount() == 2 && (index = list.locationToIndex(mouseEvent.getPoint())) >= 0) {
                        System system = (System)list.getModel().getElementAt(index);
                        PanelEditor.this.addTab(system);
                    }
                }
            }
        });
        this.buttonAdd.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                new ModalSystem();
            }
        });
        this.buttonRemove.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                try {
                    if (!((System)PanelEditor.this.jList.getSelectedValue()).getName().equals("render.lua")) {
                        new ActionRemoveSystem(((System)PanelEditor.this.jList.getSelectedValue()).getName()).actionPerformed(e);
                    } else {
                        JOptionPane.showMessageDialog(SceneEditor.frameSceneEditor, "You can't remove the render system.", "Warning", 2);
                    }
                }
                catch (IOException e1) {
                    JOptionPane.showMessageDialog(SceneEditor.frameSceneEditor, "The system can't be removed.", "Error", 0);
                }
            }
        });
    }

    private void findRemovedSystem() {
        int i = 0;
        while (i < this.jTabbedPane.getTabCount()) {
            String title = this.jTabbedPane.getTitleAt(i);
            if (!this.nameSystems.contains(title)) {
                this.jTabbedPane.remove(i);
                return;
            }
            ++i;
        }
    }

    /*
     * WARNING - void declaration
     */
    private void populateSystemList() {
        void var2_3;
        ArrayList<System> oldSystems = new ArrayList<System>();
        boolean bl = false;
        while (var2_3 < ((DefaultListModel)this.listModel).getSize()) {
            oldSystems.add((System)((DefaultListModel)this.listModel).get((int)var2_3));
            ++var2_3;
        }
        ((DefaultListModel)this.listModel).removeAllElements();
        this.nameSystems.clear();
        ((DefaultListModel)this.listModel).addElement(SceneEditor.coreEngine.getRenderSystems());
        for (System system : SceneEditor.coreEngine.getSystems()) {
            ((DefaultListModel)this.listModel).addElement(system);
            this.nameSystems.add(system.getName());
        }
        for (System system : SceneEditor.coreEngine.getSystems()) {
            boolean isNew = true;
            for (System system2 : oldSystems) {
                if (!system2.getName().equals(system.getName())) continue;
                isNew = false;
                break;
            }
            if (!isNew) continue;
            this.addTab(system);
            break;
        }
        this.revalidate();
    }
}

