/*
 * Decompiled with CFR 0.152.
 */
package ch.sparkpudding.sceneeditor.panel;

import ch.sparkpudding.coreengine.ecs.entity.Entity;
import ch.sparkpudding.sceneeditor.SceneEditor;
import ch.sparkpudding.sceneeditor.action.ActionAttach;
import ch.sparkpudding.sceneeditor.action.ActionDeleteComponent;
import ch.sparkpudding.sceneeditor.action.ActionDetach;
import ch.sparkpudding.sceneeditor.action.ActionSetComponent;
import ch.sparkpudding.sceneeditor.ecs.SEEntity;
import ch.sparkpudding.sceneeditor.panel.PanelFieldsEditor;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.AdjustmentEvent;
import java.awt.event.AdjustmentListener;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSeparator;

public class PanelComponentEditor
extends JPanel {
    private JPanel contentPanel;
    private JScrollPane jScrollPane;
    private Collection<ch.sparkpudding.coreengine.ecs.component.Component> components;
    private List<JButton> btnsDelete;
    private List<JButton> btnsDetachOrCopy;
    private List<PanelFieldsEditor> fieldGenerators;
    private SEEntity seEntity;
    private Entity entity;

    public PanelComponentEditor(SEEntity seEntity, Entity entity) {
        this.components = entity.getComponents().values();
        this.fieldGenerators = new ArrayList<PanelFieldsEditor>();
        this.btnsDelete = new ArrayList<JButton>();
        this.btnsDetachOrCopy = new ArrayList<JButton>();
        this.seEntity = seEntity;
        this.entity = entity;
        this.init();
        this.createComponents();
        this.setupLayout();
    }

    private void init() {
        this.contentPanel = new JPanel();
        this.contentPanel.setLayout(new BoxLayout(this.contentPanel, 1));
        this.jScrollPane = new JScrollPane(this.contentPanel);
        this.jScrollPane.getVerticalScrollBar().setUnitIncrement(16);
        this.jScrollPane.setVerticalScrollBarPolicy(22);
        this.jScrollPane.setHorizontalScrollBarPolicy(31);
        this.jScrollPane.getVerticalScrollBar().addAdjustmentListener(new AdjustmentListener(){

            @Override
            public void adjustmentValueChanged(AdjustmentEvent arg0) {
                PanelComponentEditor.this.repaint();
            }
        });
    }

    public int getScrollPosition() {
        return this.jScrollPane.getVerticalScrollBar().getValue();
    }

    public void setScrollPosition(int value) {
        this.jScrollPane.getVerticalScrollBar().setValue(value);
    }

    private void setupLayout() {
        this.setLayout(new BorderLayout());
        this.add((Component)this.jScrollPane, "Center");
    }

    private void createComponents() {
        this.removeAll();
        ArrayList<ch.sparkpudding.coreengine.ecs.component.Component> componentsToSort = new ArrayList<ch.sparkpudding.coreengine.ecs.component.Component>();
        for (ch.sparkpudding.coreengine.ecs.component.Component component : this.components) {
            if (component.getName().startsWith("se-")) continue;
            componentsToSort.add(component);
        }
        componentsToSort.sort(new Comparator<ch.sparkpudding.coreengine.ecs.component.Component>(){

            @Override
            public int compare(ch.sparkpudding.coreengine.ecs.component.Component arg0, ch.sparkpudding.coreengine.ecs.component.Component arg1) {
                if (arg0.getName().equals("position") || arg0.getName().equals("size")) {
                    return -1;
                }
                if (arg1.getName().equals("position") || arg1.getName().equals("size")) {
                    return 1;
                }
                return arg0.getName().compareTo(arg1.getName());
            }
        });
        for (ch.sparkpudding.coreengine.ecs.component.Component component : componentsToSort) {
            this.setupComponentsLayout(component);
        }
        this.revalidate();
    }

    private void setupComponentsLayout(ch.sparkpudding.coreengine.ecs.component.Component component) {
        boolean isSpawned;
        Box titleBar = new Box(0);
        JLabel titleComp = new JLabel(component.getName());
        JButton btnDelete = new JButton("Delete");
        JButton btnDetachOrCopy = null;
        boolean isLive = this.seEntity.getLiveEntity() == this.entity && SceneEditor.getGameState() != SceneEditor.EditorState.STOP;
        boolean bl = isSpawned = this.seEntity.getDefaultEntity() == null;
        if (!isSpawned) {
            if (isLive) {
                btnDetachOrCopy = new JButton("Copy to default");
                btnDetachOrCopy.addActionListener(new ActionSetComponent("Set " + component.getName() + " fields as initial for " + this.entity.getName(), this.seEntity.getDefaultEntity(), component));
            } else {
                String actionAttachText = "Use component template";
                String actionDetachText = "Detach from component template";
                if (Entity.getTemplates().get(this.entity.getTemplate()).hasComponent(component.getName())) {
                    actionAttachText = "Use entity template";
                    actionDetachText = "Detach from entity template";
                }
                if (component.isAttached()) {
                    btnDetachOrCopy = new JButton(actionDetachText);
                    btnDetachOrCopy.addActionListener(new ActionDetach(component));
                } else {
                    btnDetachOrCopy = new JButton(actionAttachText);
                    btnDetachOrCopy.addActionListener(new ActionAttach(this.entity, component));
                }
            }
        }
        titleComp.setFont(titleComp.getFont().deriveFont(1));
        titleBar.add(Box.createHorizontalStrut(5));
        titleBar.add(titleComp);
        titleBar.add(Box.createHorizontalGlue());
        btnDelete.addActionListener(new ActionDeleteComponent(this.seEntity, this.entity, component));
        titleBar.add(btnDelete);
        if (!isSpawned) {
            titleBar.add(btnDetachOrCopy);
        }
        this.contentPanel.add(titleBar);
        PanelFieldsEditor field = new PanelFieldsEditor(component, isLive || !component.isAttached());
        this.fieldGenerators.add(field);
        this.btnsDelete.add(btnDelete);
        this.btnsDetachOrCopy.add(btnDetachOrCopy);
        this.contentPanel.add(field);
        this.contentPanel.add(new JSeparator());
    }

    @Override
    public void setEnabled(boolean enabled) {
        for (JButton btn : this.btnsDelete) {
            btn.setEnabled(enabled);
        }
        for (JButton btn : this.btnsDetachOrCopy) {
            if (btn == null) continue;
            btn.setEnabled(enabled);
        }
        for (PanelFieldsEditor fieldGenerator : this.fieldGenerators) {
            fieldGenerator.setEnabled(enabled);
        }
        super.setEnabled(enabled);
    }
}

