/*
 * Decompiled with CFR 0.152.
 */
package ch.sparkpudding.sceneeditor.menu;

import ch.sparkpudding.sceneeditor.SceneEditor;
import ch.sparkpudding.sceneeditor.filewriter.LelWriter;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.IOException;
import javax.swing.JFileChooser;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.KeyStroke;

public class MenuFile
extends JMenu {
    private JMenuItem itemNew;
    private JMenuItem itemSave;
    private JMenuItem itemExit;

    public MenuFile() {
        this.init();
        this.addAction();
        this.addKeyStroke();
        this.addItem();
    }

    private void init() {
        this.setText("File");
        this.itemNew = new JMenuItem("New", 78);
        this.itemSave = new JMenuItem("Save", 83);
        this.itemExit = new JMenuItem("Exit", 88);
        this.itemNew.setEnabled(false);
        this.itemExit.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                System.exit(0);
            }
        });
    }

    private void addAction() {
        this.itemSave.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                LelWriter lel = new LelWriter();
                try {
                    lel.save(SceneEditor.coreEngine, String.valueOf(SceneEditor.gamePath) + "/");
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        });
        this.itemNew.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                LelWriter lel = new LelWriter();
                JFileChooser folderChooser = new JFileChooser();
                folderChooser.setFileSelectionMode(1);
                int returnVal = folderChooser.showSaveDialog(SceneEditor.frameSceneEditor);
                if (returnVal != 0) {
                    return;
                }
                String newGamePath = folderChooser.getSelectedFile().getAbsolutePath();
                lel.create(String.valueOf(newGamePath) + "/", true);
            }
        });
    }

    private void addKeyStroke() {
        this.itemNew.setAccelerator(KeyStroke.getKeyStroke(78, 576));
        this.itemSave.setAccelerator(KeyStroke.getKeyStroke(83, 128));
    }

    private void addItem() {
        this.add(this.itemNew);
        this.add(this.itemSave);
        this.addSeparator();
        this.add(this.itemExit);
    }
}

