/*
 * Decompiled with CFR 0.152.
 */
package ch.sparkpudding.sceneeditor.menu;

import ch.sparkpudding.coreengine.Scheduler;
import ch.sparkpudding.sceneeditor.SceneEditor;
import ch.sparkpudding.sceneeditor.action.AbstractAction;
import ch.sparkpudding.sceneeditor.action.ActionPasteEntity;
import ch.sparkpudding.sceneeditor.action.ActionRedo;
import ch.sparkpudding.sceneeditor.action.ActionRemoveEntity;
import ch.sparkpudding.sceneeditor.action.ActionUndo;
import ch.sparkpudding.sceneeditor.action.ActionsHistory;
import ch.sparkpudding.sceneeditor.listener.HistoryEventListener;
import ch.sparkpudding.sceneeditor.panel.modal.ModalComponent;
import ch.sparkpudding.sceneeditor.panel.modal.ModalEntity;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.KeyStroke;

public class MenuEdit
extends JMenu {
    private JMenuItem itemPauseUnpause;
    private JMenuItem itemStop;
    private JMenuItem itemUndo;
    private JMenuItem itemRedo;
    private JMenuItem itemCreateComponent;
    private JMenuItem itemCreateEntity;
    private JMenuItem itemDeleteEntity;
    private JMenuItem itemCopyEntity;
    private JMenuItem itemPasteEntity;

    public MenuEdit() {
        this.init();
        this.addAction();
        this.addKeyStroke();
        this.addItem();
    }

    private void init() {
        this.setText("Edit");
        this.itemPauseUnpause = new JMenuItem("Toggle pause");
        this.itemStop = new JMenuItem("Reset scene");
        this.itemUndo = new JMenuItem("Undo");
        this.itemRedo = new JMenuItem("Redo");
        this.itemCreateComponent = new JMenuItem("Create component");
        this.itemCreateEntity = new JMenuItem("Create entity");
        this.itemDeleteEntity = new JMenuItem("Delete entity");
        this.itemCopyEntity = new JMenuItem("Copy entity");
        this.itemPasteEntity = new JMenuItem("Paste entity");
    }

    private void addAction() {
        this.itemPauseUnpause.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                SceneEditor.coreEngine.getScheduler().schedule(Scheduler.Trigger.GAME_LOOP_START, new Runnable(){

                    @Override
                    public void run() {
                        switch (SceneEditor.getGameState()) {
                            case PLAY: {
                                SceneEditor.setGameState(SceneEditor.EditorState.PAUSE);
                                break;
                            }
                            case ERROR: {
                                SceneEditor.coreEngine.clearError();
                                SceneEditor.setGameState(SceneEditor.EditorState.PAUSE);
                                break;
                            }
                            default: {
                                SceneEditor.setGameState(SceneEditor.EditorState.PLAY);
                            }
                        }
                    }
                });
                SceneEditor.coreEngine.requestFocus();
            }
        });
        this.itemStop.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                SceneEditor.coreEngine.getScheduler().schedule(Scheduler.Trigger.GAME_LOOP_START, new Runnable(){

                    @Override
                    public void run() {
                        SceneEditor.setGameState(SceneEditor.EditorState.STOP);
                    }
                });
                SceneEditor.coreEngine.requestFocus();
            }
        });
        this.itemRedo.setAction(new ActionRedo());
        this.itemUndo.setAction(new ActionUndo());
        this.itemUndo.setEnabled(false);
        this.itemRedo.setEnabled(false);
        this.itemPasteEntity.setEnabled(false);
        this.itemCreateComponent.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                new ModalComponent(null, null);
            }
        });
        this.itemCreateEntity.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                new ModalEntity();
            }
        });
        this.itemDeleteEntity.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ActionRemoveEntity action = new ActionRemoveEntity(SceneEditor.selectedEntity, SceneEditor.currentScene.getLiveScene());
                action.actionPerformed(e);
            }
        });
        this.itemCopyEntity.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (SceneEditor.selectedEntity != null) {
                    SceneEditor.clipboardEntity = SceneEditor.selectedEntity;
                    MenuEdit.this.itemPasteEntity.setEnabled(true);
                }
            }
        });
        this.itemPasteEntity.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (SceneEditor.clipboardEntity != null) {
                    ActionPasteEntity action = new ActionPasteEntity(SceneEditor.clipboardEntity);
                    action.actionPerformed(e);
                }
            }
        });
        ActionsHistory.getInstance().addHistoryEventListener(new HistoryEventListener(){

            @Override
            public void historyEvent(int stackPointer, int stackSize) {
                if (stackPointer >= 0) {
                    MenuEdit.this.itemUndo.setEnabled(true);
                } else {
                    MenuEdit.this.itemUndo.setEnabled(false);
                }
                if (stackPointer < stackSize - 1) {
                    MenuEdit.this.itemRedo.setEnabled(true);
                } else {
                    MenuEdit.this.itemRedo.setEnabled(false);
                }
                MenuEdit.this.updateActionsHistory(stackPointer, stackSize);
            }
        });
    }

    private void addKeyStroke() {
        this.itemPauseUnpause.setAccelerator(KeyStroke.getKeyStroke(10, 128));
        this.itemStop.setAccelerator(KeyStroke.getKeyStroke(8, 128));
        this.itemCreateComponent.setAccelerator(KeyStroke.getKeyStroke(107, 192));
        this.itemUndo.setAccelerator(KeyStroke.getKeyStroke(90, 128));
        this.itemRedo.setAccelerator(KeyStroke.getKeyStroke(89, 128));
        this.itemCreateEntity.setAccelerator(KeyStroke.getKeyStroke(107, 128));
        this.itemDeleteEntity.setAccelerator(KeyStroke.getKeyStroke(127, 0));
        this.itemCopyEntity.setAccelerator(KeyStroke.getKeyStroke(67, 128));
        this.itemPasteEntity.setAccelerator(KeyStroke.getKeyStroke(86, 128));
    }

    private void addItem() {
        this.add(this.itemPauseUnpause);
        this.add(this.itemStop);
        this.addSeparator();
        this.add(this.itemUndo);
        this.add(this.itemRedo);
        this.addSeparator();
        this.add(this.itemCreateComponent);
        this.addSeparator();
        this.add(this.itemCreateEntity);
        this.add(this.itemDeleteEntity);
        this.add(this.itemCopyEntity);
        this.add(this.itemPasteEntity);
        this.addSeparator();
    }

    private void updateActionsHistory(int stackPointer, int stackSize) {
        this.removeAll();
        this.addItem();
        int i = stackSize - 1;
        while (i >= stackSize - 5 && i >= 0) {
            AbstractAction action = ActionsHistory.getInstance().getActionAt(i);
            JMenuItem jMenuItem = new JMenuItem(new ActionUndo(action));
            if (i > stackPointer) {
                jMenuItem.setEnabled(false);
            }
            this.add(jMenuItem);
            --i;
        }
        if (stackSize > 5) {
            this.add("...");
        }
    }
}

