/*
 * Decompiled with CFR 0.152.
 */
package ch.sparkpudding.sceneeditor.menu;

import ch.sparkpudding.coreengine.Camera;
import ch.sparkpudding.coreengine.ecs.component.Component;
import ch.sparkpudding.coreengine.ecs.entity.Entity;
import ch.sparkpudding.sceneeditor.SceneEditor;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.geom.Point2D;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.KeyStroke;

public class MenuCamera
extends JMenu {
    private JMenuItem resetToOrigin;
    private JMenuItem moveToEntity;
    private JMenuItem moveEntityToCamera;
    private JMenuItem moveToGameView;

    public MenuCamera() {
        this.init();
        this.addAction();
        this.addKeyStroke();
        this.addItem();
    }

    private void init() {
        this.setText("Camera");
        this.resetToOrigin = new JMenuItem("Move to origin", 79);
        this.moveToEntity = new JMenuItem("Move to selected entity", 69);
        this.moveEntityToCamera = new JMenuItem("Move selected entity to camera", 67);
        this.moveToGameView = new JMenuItem("Move camera to game view", 71);
    }

    private void addAction() {
        this.moveEntityToCamera.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                if (SceneEditor.selectedEntity != null && SceneEditor.selectedEntity.getLiveEntity().hasComponent("position")) {
                    Camera camera = SceneEditor.getEditingCamera();
                    Entity entity = SceneEditor.selectedEntity.getLiveEntity();
                    Component position = entity.getComponents().get("position");
                    Dimension halfSize = new Dimension();
                    if (entity.hasComponent("size")) {
                        halfSize.setSize(entity.getComponents().get("size").getFields().get("width").getDouble() / 2.0, entity.getComponents().get("size").getFields().get("height").getDouble() / 2.0);
                    }
                    position.getField("x").setValue((camera.getPosition().getX() + SceneEditor.coreEngine.getGameWidth() / 2.0) / (double)camera.getScaling() - halfSize.getWidth());
                    position.getField("y").setValue((camera.getPosition().getY() + SceneEditor.coreEngine.getGameHeight() / 2.0) / (double)camera.getScaling() - halfSize.getHeight());
                }
            }
        });
        this.moveToEntity.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                Camera camera = SceneEditor.getEditingCamera();
                MenuCamera.this.setCameraSettings(camera);
                if (SceneEditor.selectedEntity != null && SceneEditor.selectedEntity.getLiveEntity().hasComponent("position")) {
                    Entity entity = SceneEditor.selectedEntity.getLiveEntity();
                    Component position = entity.getComponents().get("position");
                    Dimension halfSize = new Dimension();
                    if (entity.hasComponent("size")) {
                        halfSize.setSize(entity.getComponents().get("size").getFields().get("width").getDouble() / 2.0, entity.getComponents().get("size").getFields().get("height").getDouble() / 2.0);
                    }
                    camera.centerTargetAt((float)(position.getField("x").getDouble() + halfSize.getWidth()), (float)(position.getField("y").getDouble() + halfSize.getHeight()));
                }
            }
        });
        this.resetToOrigin.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                Camera camera = SceneEditor.getEditingCamera();
                MenuCamera.this.setCameraSettings(camera);
                if (camera.getScaling() > 1.0f) {
                    SceneEditor.getEditingCamera().setScalingPoint(new Point2D.Double(camera.getPosition().getX() / (double)camera.getScaling(), camera.getPosition().getY() / (double)camera.getScaling()));
                } else {
                    camera.setScalingPoint(new Point2D.Double(camera.getPosition().getX() * (double)camera.getScaling(), camera.getPosition().getY() * (double)camera.getScaling()));
                }
                camera.setTargetPosition(0.0f, 0.0f);
                camera.setTargetScaling(1.0f);
            }
        });
        this.moveToGameView.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                Camera camera = SceneEditor.getEditingCamera();
                Camera gameCamera = SceneEditor.getGameCamera();
                camera.setTranslateMode(Camera.Mode.NO_FOLLOW);
                camera.setPosition(gameCamera.getPosition().getX(), gameCamera.getPosition().getY());
                camera.setTargetToPosition();
                camera.setScalingPoint(new Point2D.Double(SceneEditor.coreEngine.getGameWidth() / 2.0, SceneEditor.coreEngine.getGameHeight() / 2.0));
                camera.setSmoothScaleSpeedCoeff(0.1f);
                camera.setScaling(gameCamera.getScaling());
                camera.setTargetScaling(gameCamera.getScaling());
            }
        });
    }

    private void setCameraSettings(Camera camera) {
        camera.setTranslateMode(Camera.Mode.SMOOTH);
        camera.setSmoothScaleSpeedCoeff(0.05f);
        camera.setSmoothSpeedCoeff(new Point2D.Double(0.1, 0.1));
    }

    private void addKeyStroke() {
        this.moveToGameView.setAccelerator(KeyStroke.getKeyStroke(48, 128));
        this.resetToOrigin.setAccelerator(KeyStroke.getKeyStroke(48, 192));
        this.moveToEntity.setAccelerator(KeyStroke.getKeyStroke(57, 128));
        this.moveEntityToCamera.setAccelerator(KeyStroke.getKeyStroke(57, 192));
    }

    private void addItem() {
        this.add(this.moveToGameView);
        this.add(this.resetToOrigin);
        this.add(this.moveToEntity);
        this.add(this.moveEntityToCamera);
    }
}

