/*
 * Decompiled with CFR 0.152.
 */
package ch.sparkpudding.sceneeditor.filewriter;

import ch.sparkpudding.coreengine.CoreEngine;
import ch.sparkpudding.coreengine.ecs.component.Component;
import ch.sparkpudding.coreengine.ecs.component.Field;
import ch.sparkpudding.coreengine.ecs.entity.Entity;
import ch.sparkpudding.coreengine.ecs.entity.Scene;
import java.io.File;
import java.io.IOException;
import java.nio.file.FileSystemNotFoundException;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardCopyOption;
import java.nio.file.spi.FileSystemProvider;
import java.util.Collections;
import java.util.Map;
import javax.swing.JOptionPane;

public class LelWriter {
    /*
     * WARNING - void declaration
     */
    public void save(CoreEngine coreEngine, String directory) throws IOException {
        void var5_8;
        String[] requiredFiles;
        String[] stringArray = requiredFiles = new String[]{"", "assets", "assets/music", "assets/sounds", "assets/textures", "components", "entitytemplates", "scenes", "systems"};
        int n = requiredFiles.length;
        boolean n2 = false;
        while (var5_8 < n) {
            String fileName = stringArray[var5_8];
            new File(String.valueOf(directory) + fileName).mkdir();
            ++var5_8;
        }
        new File(String.valueOf(directory) + "metadata.xml").createNewFile();
        Files.write(Paths.get(String.valueOf(directory) + "metadata.xml", new String[0]), this.xmlFromMetadata().getBytes(), new OpenOption[0]);
        Map<String, Scene> scenes = coreEngine.getScenes();
        for (Map.Entry<String, Scene> entry : scenes.entrySet()) {
            File fScene = new File(String.valueOf(directory) + "/scenes/" + entry.getKey() + ".xml");
            String xmlScene = this.xmlFromScene(entry.getValue());
            Files.write(fScene.toPath(), xmlScene.getBytes(), new OpenOption[0]);
        }
        for (Map.Entry<String, Object> entry : Entity.getTemplates().entrySet()) {
            File fTemplate = new File(String.valueOf(directory) + "/entitytemplates/" + entry.getKey() + ".xml");
            String xmlEntity = this.xmlFromEntityTemplate((Entity)entry.getValue());
            Files.write(fTemplate.toPath(), xmlEntity.getBytes(), new OpenOption[0]);
        }
        for (Map.Entry<String, Object> entry : Component.getTemplates().entrySet()) {
            if (((Component)entry.getValue()).getName().startsWith("se-")) continue;
            File fComponent = new File(String.valueOf(directory) + "/components/" + entry.getKey() + ".xml");
            String xmlComponent = this.xmlFromComponent((Component)entry.getValue());
            Files.write(fComponent.toPath(), xmlComponent.getBytes(), new OpenOption[0]);
        }
    }

    public void create(String directory, boolean isEmptyGame) {
        try {
            Path src = isEmptyGame ? Paths.get("./resources/emptygame", new String[0]) : Paths.get("./resources/basicgame", new String[0]);
            Path dest = Paths.get(directory, new String[0]);
            if ("jar".equals(src.toUri().getScheme())) {
                for (FileSystemProvider provider : FileSystemProvider.installedProviders()) {
                    if (!provider.getScheme().equalsIgnoreCase("jar")) continue;
                    try {
                        provider.getFileSystem(src.toUri());
                    }
                    catch (FileSystemNotFoundException e) {
                        provider.newFileSystem(src.toUri(), Collections.emptyMap());
                    }
                }
            }
            Files.walk(src, new FileVisitOption[0]).forEach(source -> {
                try {
                    Files.copy(source, dest.resolve(src.relativize((Path)source)), StandardCopyOption.REPLACE_EXISTING);
                }
                catch (IOException e) {
                    JOptionPane.showMessageDialog(null, e.getStackTrace(), "IO Error", 0);
                }
            });
        }
        catch (IOException e) {
            e.printStackTrace();
            JOptionPane.showMessageDialog(null, e.getStackTrace(), "IO Error", 0);
        }
    }

    private String xmlFromMetadata() {
        return "<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n<lel>\n\t<version>0.1</version>\n</lel>";
    }

    private String xmlFromScene(Scene scene) {
        String xml = "<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n";
        xml = String.valueOf(xml) + "<scene name=\"" + scene.getName() + "\">\n";
        for (Entity entity : scene.getDefaultEntities()) {
            xml = String.valueOf(xml) + "\t<entity name=\"" + entity.getName() + "\" template=\"" + entity.getTemplate() + "\" z-index=\"" + entity.getZIndex() + "\">\n";
            for (Component component : entity.getComponents().values()) {
                if (component.getName().startsWith("se-") || component.isAttached() && Entity.getTemplates().get(entity.getTemplate()).hasComponent(component.getName())) continue;
                xml = String.valueOf(xml) + "\t\t<component template=\"" + component.getTemplateName() + "\">\n";
                if (!component.isAttached()) {
                    for (Field field : component.getFields().values()) {
                        xml = String.valueOf(xml) + "\t\t\t<field name=\"" + field.getName() + "\">" + field.getValue() + "</field>\n";
                    }
                }
                xml = String.valueOf(xml) + "\t\t</component>\n";
            }
            for (Map.Entry entry : Entity.getTemplates().get(entity.getTemplate())) {
                if (((Component)entry.getValue()).getName().startsWith("se-") || entity.getComponents().keySet().contains(((Component)entry.getValue()).getName())) continue;
                xml = String.valueOf(xml) + "<component template=\"" + ((Component)entry.getValue()).getName() + "\" deleted=\"true\"/>";
            }
            xml = String.valueOf(xml) + "</entity>\n";
        }
        xml = String.valueOf(xml) + "</scene>";
        return xml;
    }

    private String xmlFromEntityTemplate(Entity entity) {
        String xml = "<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n";
        xml = String.valueOf(xml) + "<entity-template name=\"" + entity.getTemplate() + "\">\n";
        for (Component component : entity.getComponents().values()) {
            xml = String.valueOf(xml) + "\t<component template=\"" + component.getTemplateName() + "\">\n";
            for (Field field : component.getFields().values()) {
                xml = String.valueOf(xml) + "\t\t<field name=\"" + field.getName() + "\">" + field.getValue() + "</field>\n";
            }
            xml = String.valueOf(xml) + "\t</component>\n";
        }
        xml = String.valueOf(xml) + "</entity-template>";
        return xml;
    }

    private String xmlFromComponent(Component component) {
        String xml = "<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n";
        xml = String.valueOf(xml) + "<component name=\"" + component.getName() + "\">\n";
        for (Field field : component.getFields().values()) {
            xml = String.valueOf(xml) + "\t<field type=\"" + (Object)((Object)field.getType()) + "\" name=\"" + field.getName() + "\">" + field.getValue() + "</field>\n";
        }
        xml = String.valueOf(xml) + "</component>";
        return xml;
    }
}

