/*
 * Decompiled with CFR 0.152.
 */
package ch.sparkpudding.sceneeditor.action;

import ch.sparkpudding.sceneeditor.action.AbstractAction;
import ch.sparkpudding.sceneeditor.listener.HistoryEventListener;
import java.util.ArrayList;
import java.util.List;
import java.util.Stack;

public class ActionsHistory {
    private static ActionsHistory INSTANCE = new ActionsHistory();
    private List<HistoryEventListener> eventListeners;
    private int stackPointer = -1;
    private Stack<AbstractAction> actionsStack = new Stack();

    private ActionsHistory() {
        this.eventListeners = new ArrayList<HistoryEventListener>();
    }

    public void insertAction(AbstractAction action) {
        this.deleteElementsAfterPointer();
        this.actionsStack.push(action);
        ++this.stackPointer;
        this.fireHistoryEvent();
    }

    private void deleteElementsAfterPointer() {
        if (this.actionsStack.size() < 1) {
            return;
        }
        int i = this.actionsStack.size() - 1;
        while (i > this.stackPointer) {
            this.actionsStack.remove(i);
            --i;
        }
    }

    public AbstractAction getActionAt(int index) {
        return (AbstractAction)this.actionsStack.get(index);
    }

    public AbstractAction undo() {
        AbstractAction action = (AbstractAction)this.actionsStack.get(this.stackPointer);
        action.undoAction();
        --this.stackPointer;
        this.fireHistoryEvent();
        return action;
    }

    public AbstractAction redo() {
        if (this.stackPointer == this.actionsStack.size() - 1) {
            return null;
        }
        ++this.stackPointer;
        AbstractAction action = (AbstractAction)this.actionsStack.get(this.stackPointer);
        action.doAction();
        this.fireHistoryEvent();
        return action;
    }

    public void addHistoryEventListener(HistoryEventListener evtListener) {
        this.eventListeners.add(evtListener);
    }

    public boolean removeHistoryEventListener(HistoryEventListener evtListener) {
        return this.eventListeners.remove(evtListener);
    }

    public void removeAllHistoryEventListener() {
        this.eventListeners.clear();
    }

    private void fireHistoryEvent() {
        for (HistoryEventListener historyEventListener : this.eventListeners) {
            historyEventListener.historyEvent(this.stackPointer, this.actionsStack.size());
        }
    }

    public static ActionsHistory getInstance() {
        return INSTANCE;
    }
}

