/*
 * Decompiled with CFR 0.152.
 */
package ch.sparkpudding.sceneeditor.action;

import ch.sparkpudding.coreengine.Scheduler;
import ch.sparkpudding.sceneeditor.SceneEditor;
import ch.sparkpudding.sceneeditor.action.AbstractAction;
import ch.sparkpudding.sceneeditor.ecs.SEEntity;
import javax.swing.SwingUtilities;

public class ActionSetZIndex
extends AbstractAction {
    int zIndex;
    int previousZIndex;
    SEEntity entity;

    public ActionSetZIndex(SEEntity entity, int zIndex) {
        super("Change z-index of " + entity.getLiveEntity().getName() + " to " + zIndex);
        this.entity = entity;
        this.previousZIndex = entity.getLiveEntity().getZIndex();
        this.zIndex = zIndex;
    }

    @Override
    public boolean doAction() {
        SceneEditor.coreEngine.getScheduler().schedule(Scheduler.Trigger.GAME_LOOP_START, new Runnable(){

            @Override
            public void run() {
                ActionSetZIndex.this.entity.getLiveEntity().setZIndex(ActionSetZIndex.this.zIndex);
                ActionSetZIndex.this.entity.getDefaultEntity().setZIndex(ActionSetZIndex.this.zIndex);
                SceneEditor.coreEngine.notifyZIndexChange();
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        SceneEditor.fireEntityListChanged();
                    }
                });
            }
        });
        return true;
    }

    @Override
    public void undoAction() {
        SceneEditor.coreEngine.getScheduler().schedule(Scheduler.Trigger.GAME_LOOP_START, new Runnable(){

            @Override
            public void run() {
                ActionSetZIndex.this.entity.getLiveEntity().setZIndex(ActionSetZIndex.this.previousZIndex);
                ActionSetZIndex.this.entity.getDefaultEntity().setZIndex(ActionSetZIndex.this.previousZIndex);
                SceneEditor.coreEngine.notifyZIndexChange();
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        SceneEditor.fireEntityListChanged();
                    }
                });
            }
        });
    }
}

