/*
 * Decompiled with CFR 0.152.
 */
package ch.sparkpudding.sceneeditor.action;

import ch.sparkpudding.coreengine.ecs.component.Component;
import ch.sparkpudding.coreengine.ecs.entity.Entity;
import ch.sparkpudding.sceneeditor.SceneEditor;
import ch.sparkpudding.sceneeditor.action.AbstractAction;
import java.util.Map;

public class ActionSetEntityTemplate
extends AbstractAction {
    Entity newTemplateEntity;
    Entity previousTemplateEntity;
    String previousExistingTemplateEntityName;
    String newTemplateName;

    public ActionSetEntityTemplate(Entity entity, String templateName) {
        super("Change/create template " + templateName);
        this.newTemplateName = templateName;
        this.newTemplateEntity = entity;
        this.previousExistingTemplateEntityName = entity.getTemplate();
        this.previousTemplateEntity = Entity.getTemplates().get(this.newTemplateName);
    }

    @Override
    public boolean doAction() {
        this.newTemplateEntity.setTemplate(this.newTemplateName);
        Entity.addTemplate(this.newTemplateEntity);
        for (Map.Entry<String, Component> componentEntry : this.newTemplateEntity.getComponents().entrySet()) {
            componentEntry.getValue().setAttached(true, false);
        }
        SceneEditor.fireSelectedEntityChanged();
        return true;
    }

    @Override
    public void undoAction() {
        if (this.previousTemplateEntity == null) {
            this.newTemplateEntity.setTemplate(this.previousExistingTemplateEntityName);
            Entity.getTemplates().remove(this.newTemplateName);
        } else {
            this.newTemplateEntity.setTemplate(this.previousTemplateEntity.getTemplate());
            Entity.addTemplate(this.previousTemplateEntity);
        }
        SceneEditor.fireSelectedEntityChanged();
    }
}

