/*
 * Decompiled with CFR 0.152.
 */
package ch.sparkpudding.sceneeditor.action;

import ch.sparkpudding.coreengine.Scheduler;
import ch.sparkpudding.sceneeditor.SceneEditor;
import ch.sparkpudding.sceneeditor.action.AbstractAction;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import javax.swing.SwingUtilities;

public class ActionRemoveSystem
extends AbstractAction {
    private String name;
    private byte[] fileContent;

    public ActionRemoveSystem(String name) throws IOException {
        super("Remove system (" + name + ")");
        this.name = name;
        this.fileContent = Files.readAllBytes(Paths.get(String.valueOf(SceneEditor.coreEngine.getGameFolder()) + "/systems/" + name, new String[0]));
    }

    @Override
    public boolean doAction() {
        SceneEditor.coreEngine.getScheduler().schedule(Scheduler.Trigger.GAME_LOOP_START, new Runnable(){

            @Override
            public void run() {
                Path newFilePath = Paths.get(String.valueOf(SceneEditor.coreEngine.getGameFolder()) + "/systems/" + ActionRemoveSystem.this.name, new String[0]);
                try {
                    Files.delete(newFilePath);
                    SceneEditor.coreEngine.reloadSystemsFromDisk();
                    SwingUtilities.invokeLater(new Runnable(){

                        @Override
                        public void run() {
                            SceneEditor.fireSystemListChanged();
                        }
                    });
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        });
        return true;
    }

    @Override
    public void undoAction() {
        SceneEditor.coreEngine.getScheduler().schedule(Scheduler.Trigger.GAME_LOOP_START, new Runnable(){

            @Override
            public void run() {
                Path newFilePath = Paths.get(String.valueOf(SceneEditor.coreEngine.getGameFolder()) + "/systems/" + ActionRemoveSystem.this.name, new String[0]);
                try {
                    Files.write(newFilePath, ActionRemoveSystem.this.fileContent, new OpenOption[0]);
                    SceneEditor.coreEngine.reloadSystemsFromDisk();
                    SwingUtilities.invokeLater(new Runnable(){

                        @Override
                        public void run() {
                            SceneEditor.fireSystemListChanged();
                        }
                    });
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        });
    }
}

