/*
 * Decompiled with CFR 0.152.
 */
package ch.sparkpudding.sceneeditor.action;

import ch.sparkpudding.coreengine.Scheduler;
import ch.sparkpudding.coreengine.ecs.entity.Scene;
import ch.sparkpudding.sceneeditor.SceneEditor;
import ch.sparkpudding.sceneeditor.action.AbstractAction;
import ch.sparkpudding.sceneeditor.ecs.SEEntity;
import javax.swing.SwingUtilities;

public class ActionRemoveEntity
extends AbstractAction {
    private static final long serialVersionUID = 1L;
    private SEEntity entity;
    private Scene scene;

    public ActionRemoveEntity(SEEntity entity, Scene scene) {
        super("Remove entity (" + entity.getDefaultEntity().getName() + ")");
        this.entity = entity;
        this.scene = scene;
    }

    @Override
    public void undoAction() {
        SceneEditor.coreEngine.getScheduler().schedule(Scheduler.Trigger.GAME_LOOP_START, new Runnable(){

            @Override
            public void run() {
                if (ActionRemoveEntity.this.entity.getDefaultEntity() != null) {
                    ActionRemoveEntity.this.scene.addDefault(ActionRemoveEntity.this.entity.getDefaultEntity());
                }
                ActionRemoveEntity.this.scene.addEntity(ActionRemoveEntity.this.entity.getLiveEntity());
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        SceneEditor.createEntityList();
                    }
                });
            }
        });
    }

    @Override
    public boolean doAction() {
        SceneEditor.coreEngine.getScheduler().schedule(Scheduler.Trigger.GAME_LOOP_START, new Runnable(){

            @Override
            public void run() {
                if (ActionRemoveEntity.this.entity.getDefaultEntity() != null) {
                    SceneEditor.coreEngine.deleteDefaultEntity(ActionRemoveEntity.this.entity.getDefaultEntity());
                }
                SceneEditor.coreEngine.deleteEntity(ActionRemoveEntity.this.entity.getLiveEntity());
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        if (ActionRemoveEntity.this.entity == SceneEditor.selectedEntity) {
                            SceneEditor.selectedEntity = null;
                            SceneEditor.fireSelectedEntityChanged();
                        }
                        SceneEditor.createEntityList();
                    }
                });
            }
        });
        return true;
    }
}

