/*
 * Decompiled with CFR 0.152.
 */
package ch.sparkpudding.sceneeditor.action;

import ch.sparkpudding.coreengine.Scheduler;
import ch.sparkpudding.coreengine.ecs.component.Component;
import ch.sparkpudding.coreengine.ecs.entity.Entity;
import ch.sparkpudding.sceneeditor.SceneEditor;
import ch.sparkpudding.sceneeditor.action.AbstractAction;
import ch.sparkpudding.sceneeditor.ecs.SEEntity;
import java.awt.geom.Point2D;
import javax.swing.SwingUtilities;

public class ActionPasteEntity
extends AbstractAction {
    private Entity newDefaultEntity;
    private Entity newLiveEntity;

    public ActionPasteEntity(SEEntity entity) {
        super("Paste entity (" + entity.getLiveEntity().getName() + ")");
        this.newDefaultEntity = new Entity(entity.getLiveEntity());
        this.newDefaultEntity.removeComponent("se-selected");
        if (this.newDefaultEntity.hasComponent("position") && this.newDefaultEntity.hasComponent("size")) {
            Component size = this.newDefaultEntity.getComponents().get("size");
            double width = size.getField("width").getDouble();
            double height = size.getField("height").getDouble();
            Point2D worldMousePosition = SceneEditor.coreEngine.panelPositionToWorld(SceneEditor.coreEngine.getInput().getMousePosition());
            this.newDefaultEntity.getComponents().get("position").getField("x").setValue(worldMousePosition.getX() - width / 2.0);
            this.newDefaultEntity.getComponents().get("position").getField("y").setValue(worldMousePosition.getY() - height / 2.0);
        }
        this.newLiveEntity = new Entity(this.newDefaultEntity);
    }

    @Override
    public boolean doAction() {
        SceneEditor.coreEngine.getScheduler().schedule(Scheduler.Trigger.GAME_LOOP_START, new Runnable(){

            @Override
            public void run() {
                SceneEditor.coreEngine.addEntity(ActionPasteEntity.this.newLiveEntity);
                SceneEditor.coreEngine.getCurrentScene().addDefault(ActionPasteEntity.this.newDefaultEntity);
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        SceneEditor.createEntityList();
                        SceneEditor.coreEngine.getScheduler().schedule(Scheduler.Trigger.GAME_LOOP_START, new Runnable(){

                            @Override
                            public void run() {
                                for (SEEntity seEntity : SceneEditor.currentScene.getSEEntities()) {
                                    if (seEntity.getLiveEntity() != ActionPasteEntity.this.newLiveEntity) continue;
                                    seEntity.setSelected(true);
                                    break;
                                }
                            }
                        });
                    }
                });
            }
        });
        return true;
    }

    @Override
    public void undoAction() {
        SceneEditor.coreEngine.getScheduler().schedule(Scheduler.Trigger.GAME_LOOP_START, new Runnable(){

            @Override
            public void run() {
                SceneEditor.coreEngine.deleteDefaultEntity(ActionPasteEntity.this.newDefaultEntity);
                SceneEditor.coreEngine.deleteEntity(ActionPasteEntity.this.newLiveEntity);
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        SceneEditor.createEntityList();
                    }
                });
            }
        });
    }
}

