/*
 * Decompiled with CFR 0.152.
 */
package ch.sparkpudding.sceneeditor.action;

import ch.sparkpudding.coreengine.ecs.component.Field;
import ch.sparkpudding.sceneeditor.action.AbstractAction;
import javax.swing.JTextField;

public class ActionChangeTextField
extends AbstractAction {
    private Field field;
    private String value;
    private String oldValue;
    private JTextField textField;

    public ActionChangeTextField(Field field, String value, String componentName) {
        super("Value (" + value + ")");
        this.field = field;
        this.value = value;
        this.oldValue = field.getValue().toString();
    }

    public ActionChangeTextField(Field field, JTextField textField, String componentName) {
        this(field, textField.getText(), componentName);
        this.textField = textField;
    }

    @Override
    public void undoAction() {
        this.field.setValueFromString(this.oldValue);
        if (this.textField != null) {
            this.textField.setText(this.oldValue);
        }
    }

    @Override
    public boolean doAction() {
        if (this.oldValue.equals(this.value)) {
            return false;
        }
        this.field.setValueFromString(this.value);
        if (this.textField != null) {
            this.textField.setText(this.value);
        }
        return true;
    }
}

