/*
 * Decompiled with CFR 0.152.
 */
package ch.sparkpudding.sceneeditor.action;

import ch.sparkpudding.coreengine.ecs.component.Component;
import ch.sparkpudding.coreengine.ecs.component.Field;
import ch.sparkpudding.coreengine.ecs.entity.Entity;
import ch.sparkpudding.sceneeditor.SceneEditor;
import ch.sparkpudding.sceneeditor.action.AbstractAction;
import java.util.HashMap;
import java.util.Map;

public class ActionAttach
extends AbstractAction {
    private Component component;
    private Entity entity;
    private Map<String, String> oldValues;

    public ActionAttach(Entity entity, Component component) {
        super("Attach component " + component.getName());
        this.component = component;
        this.entity = entity;
    }

    @Override
    public boolean doAction() {
        this.oldValues = new HashMap<String, String>();
        for (Field field : this.component.getFields().values()) {
            this.oldValues.put(field.getName(), field.getValue().toString());
        }
        this.entity.setComponentAttached(this.component.getName(), true);
        SceneEditor.fireSelectedEntityChanged();
        return true;
    }

    @Override
    public void undoAction() {
        this.entity.setComponentAttached(this.component.getName(), false);
        for (Map.Entry<String, String> field : this.oldValues.entrySet()) {
            this.component.getField(field.getKey()).setValueFromString(field.getValue());
        }
        SceneEditor.fireSelectedEntityChanged();
    }
}

