/*
 * Decompiled with CFR 0.152.
 */
package ch.sparkpudding.sceneeditor.action;

import ch.sparkpudding.coreengine.Scheduler;
import ch.sparkpudding.sceneeditor.SceneEditor;
import ch.sparkpudding.sceneeditor.action.AbstractAction;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import javax.swing.SwingUtilities;

public class ActionAddSystem
extends AbstractAction {
    private String name;
    private String content = "function getRequiredComponents()\n\treturn {\"position\", \"size\"}\nend\n\nfunction updateEntities(entity)\n\t-- entity.position.x = entity.position.x + 1\nend\n\n--[[ Uncomment to loop manually\nfunction update()\n\tfor i, entity in ipairs(entities) do\n\tend\nend\n---]]";

    public ActionAddSystem(String name) {
        super("Add system (" + name + ")");
        this.name = name;
    }

    @Override
    public boolean doAction() {
        SceneEditor.coreEngine.getScheduler().schedule(Scheduler.Trigger.GAME_LOOP_START, new Runnable(){

            @Override
            public void run() {
                Path newFilePath = Paths.get(String.valueOf(SceneEditor.coreEngine.getGameFolder()) + "/systems/" + ActionAddSystem.this.name + ".lua", new String[0]);
                try {
                    Files.write(newFilePath, ActionAddSystem.this.content.getBytes(), new OpenOption[0]);
                    SceneEditor.coreEngine.reloadSystemsFromDisk();
                    SwingUtilities.invokeLater(new Runnable(){

                        @Override
                        public void run() {
                            SceneEditor.fireSystemListChanged();
                        }
                    });
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        });
        return true;
    }

    @Override
    public void undoAction() {
        SceneEditor.coreEngine.getScheduler().schedule(Scheduler.Trigger.GAME_LOOP_START, new Runnable(){

            @Override
            public void run() {
                Path newFilePath = Paths.get(String.valueOf(SceneEditor.coreEngine.getGameFolder()) + "/systems/" + ActionAddSystem.this.name + ".lua", new String[0]);
                try {
                    Files.delete(newFilePath);
                    SceneEditor.coreEngine.reloadSystemsFromDisk();
                    SwingUtilities.invokeLater(new Runnable(){

                        @Override
                        public void run() {
                            SceneEditor.fireSystemListChanged();
                        }
                    });
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        });
    }
}

