/*
 * Decompiled with CFR 0.152.
 */
package ch.sparkpudding.sceneeditor.action;

import ch.sparkpudding.coreengine.Camera;
import ch.sparkpudding.coreengine.Scheduler;
import ch.sparkpudding.coreengine.ecs.component.Component;
import ch.sparkpudding.coreengine.ecs.entity.Entity;
import ch.sparkpudding.sceneeditor.SceneEditor;
import ch.sparkpudding.sceneeditor.action.AbstractAction;
import ch.sparkpudding.sceneeditor.ecs.SEEntity;
import javax.swing.SwingUtilities;

public class ActionAddEntity
extends AbstractAction {
    private Entity newDefaultEntity;
    private Entity newLiveEntity;

    public ActionAddEntity(String name, String templateName) {
        super("Add entity (" + name + ")");
        this.newDefaultEntity = new Entity(Entity.getTemplates().get(templateName));
        this.newDefaultEntity.setName(name);
        if (this.newDefaultEntity.hasComponent("position") && this.newDefaultEntity.hasComponent("size")) {
            Camera camera = SceneEditor.coreEngine.getCamera();
            Component size = this.newDefaultEntity.getComponents().get("size");
            double width = size.getField("width").getDouble();
            double height = size.getField("height").getDouble();
            this.newDefaultEntity.getComponents().get("position").setAttached(false, false);
            this.newDefaultEntity.getComponents().get("position").getField("x").setValue((camera.getPosition().getX() + SceneEditor.coreEngine.getGameWidth() / 2.0 - width / 2.0) / (double)camera.getScaling());
            this.newDefaultEntity.getComponents().get("position").getField("y").setValue((camera.getPosition().getY() + SceneEditor.coreEngine.getGameHeight() / 2.0 - height / 2.0) / (double)camera.getScaling());
        }
        this.newLiveEntity = new Entity(this.newDefaultEntity);
    }

    @Override
    public boolean doAction() {
        SceneEditor.coreEngine.getScheduler().schedule(Scheduler.Trigger.GAME_LOOP_START, new Runnable(){

            @Override
            public void run() {
                SceneEditor.coreEngine.addEntity(ActionAddEntity.this.newLiveEntity);
                SceneEditor.coreEngine.getCurrentScene().addDefault(ActionAddEntity.this.newDefaultEntity);
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        SceneEditor.createEntityList();
                        SceneEditor.coreEngine.getScheduler().schedule(Scheduler.Trigger.GAME_LOOP_START, new Runnable(){

                            @Override
                            public void run() {
                                for (SEEntity seEntity : SceneEditor.currentScene.getSEEntities()) {
                                    if (SceneEditor.getGameState() != SceneEditor.EditorState.STOP) {
                                        if (seEntity.getLiveEntity() != ActionAddEntity.this.newLiveEntity) continue;
                                        seEntity.setSelected(true);
                                        break;
                                    }
                                    if (seEntity.getLiveEntity() != ActionAddEntity.this.newDefaultEntity) continue;
                                    seEntity.setSelected(true);
                                    break;
                                }
                            }
                        });
                    }
                });
            }
        });
        return true;
    }

    @Override
    public void undoAction() {
        SceneEditor.coreEngine.getScheduler().schedule(Scheduler.Trigger.GAME_LOOP_START, new Runnable(){

            @Override
            public void run() {
                SceneEditor.coreEngine.deleteDefaultEntity(ActionAddEntity.this.newDefaultEntity);
                SceneEditor.coreEngine.deleteEntity(ActionAddEntity.this.newLiveEntity);
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        if (ActionAddEntity.this.newLiveEntity == SceneEditor.selectedEntity.getLiveEntity()) {
                            SceneEditor.selectedEntity = null;
                            SceneEditor.fireSelectedEntityChanged();
                        }
                        SceneEditor.createEntityList();
                    }
                });
            }
        });
    }
}

