/*
 * Decompiled with CFR 0.152.
 */
package ch.sparkpudding.sceneeditor.action;

import ch.sparkpudding.coreengine.Scheduler;
import ch.sparkpudding.coreengine.ecs.component.Component;
import ch.sparkpudding.coreengine.ecs.entity.Entity;
import ch.sparkpudding.sceneeditor.SceneEditor;
import ch.sparkpudding.sceneeditor.action.AbstractAction;
import ch.sparkpudding.sceneeditor.ecs.SEEntity;
import javax.swing.SwingUtilities;

public class ActionAddComponent
extends AbstractAction {
    Component component;
    Entity entity;
    SEEntity seEntity;

    public ActionAddComponent(SEEntity seEntity, Entity entity, Component component) {
        super("Add component (" + component.getName() + ")");
        this.component = component;
        this.entity = entity;
        this.seEntity = seEntity;
    }

    @Override
    public boolean doAction() {
        SceneEditor.coreEngine.getScheduler().schedule(Scheduler.Trigger.GAME_LOOP_START, new Runnable(){

            @Override
            public void run() {
                ActionAddComponent.this.entity.addComponent(ActionAddComponent.this.component);
                SceneEditor.coreEngine.notifySystemsOfNewComponent(ActionAddComponent.this.entity, ActionAddComponent.this.component);
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        SceneEditor.fireSelectedEntityChanged();
                    }
                });
            }
        });
        return true;
    }

    @Override
    public void undoAction() {
        SceneEditor.coreEngine.getScheduler().schedule(Scheduler.Trigger.GAME_LOOP_START, new Runnable(){

            @Override
            public void run() {
                SceneEditor.coreEngine.deleteComponent(ActionAddComponent.this.entity, ActionAddComponent.this.component.getName());
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        SceneEditor.fireSelectedEntityChanged();
                    }
                });
            }
        });
    }
}

