/*
 * Decompiled with CFR 0.152.
 */
package ch.sparkpudding.sceneeditor;

import ch.sparkpudding.coreengine.Camera;
import ch.sparkpudding.coreengine.CoreEngine;
import ch.sparkpudding.coreengine.ecs.entity.Scene;
import ch.sparkpudding.sceneeditor.FrameSceneEditor;
import ch.sparkpudding.sceneeditor.ecs.SEEntity;
import ch.sparkpudding.sceneeditor.ecs.SEScene;
import ch.sparkpudding.sceneeditor.listener.EntityEventListener;
import ch.sparkpudding.sceneeditor.listener.GameStateEventListener;
import ch.sparkpudding.sceneeditor.listener.SystemEventListener;
import java.awt.Color;
import java.awt.geom.Point2D;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import javax.swing.SwingUtilities;
import javax.swing.event.EventListenerList;

public class SceneEditor {
    public static FrameSceneEditor frameSceneEditor;
    public static CoreEngine coreEngine;
    public static String gamePath;
    public static Map<String, SEScene> seScenes;
    public static SEScene currentScene;
    public static SEEntity selectedEntity;
    public static SEEntity clipboardEntity;
    private static EventListenerList listenerList;
    private static Camera camera;
    private static Camera gameCamera;
    private static EditorState gameState;
    private static EditorState previousState;

    static {
        listenerList = new EventListenerList();
        seScenes = new HashMap<String, SEScene>();
        camera = new Camera();
    }

    public static EditorState getGameState() {
        return gameState;
    }

    public static void clearError() {
        if (coreEngine.isInError()) {
            coreEngine.clearError();
            if (previousState != null) {
                SceneEditor.setGameState(previousState);
            } else {
                SceneEditor.setGameState(EditorState.PAUSE);
            }
        }
    }

    public static void setGameState(EditorState state) {
        if (gameState != EditorState.ERROR) {
            previousState = gameState;
        }
        gameState = state;
        switch (state) {
            case PAUSE: {
                SceneEditor.swapToSceneEditorCamera();
                coreEngine.setEditingPause(true, true);
                break;
            }
            case PLAY: {
                if (previousState == EditorState.STOP) {
                    coreEngine.resetCurrentScene(false);
                    SceneEditor.createEntityList();
                }
                SceneEditor.swapToGameCamera();
                coreEngine.setEditingPause(false, true);
                break;
            }
            case STOP: {
                SceneEditor.swapToSceneEditorCamera();
                coreEngine.resetCurrentScene(true);
                SceneEditor.createEntityList();
                coreEngine.setEditingPause(true, true);
                if (!coreEngine.isInError()) break;
                SceneEditor.setGameState(EditorState.ERROR);
                break;
            }
            case ERROR: {
                SceneEditor.swapToSceneEditorCamera();
                SceneEditor.createEntityList();
                coreEngine.setEditingPause(true, true);
                break;
            }
        }
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                SceneEditor.fireGameStateChanged();
            }
        });
    }

    public static void createEntityList() {
        Map<String, Scene> scenes = coreEngine.getScenes();
        seScenes.clear();
        for (Scene scene : scenes.values()) {
            SEScene seScene = new SEScene(scene);
            seScenes.put(scene.getName(), seScene);
            if (coreEngine.getCurrentScene() != scene) continue;
            currentScene = seScene;
        }
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                SceneEditor.fireEntityListChanged();
            }
        });
    }

    private static void swapToSceneEditorCamera() {
        if (coreEngine.isEditingPause()) {
            return;
        }
        coreEngine.setBlackBarsColor(new Color(0, 0, 0, 127));
        gameCamera = coreEngine.getCamera();
        camera.setTranslateMode(Camera.Mode.NO_FOLLOW);
        camera.setPosition(gameCamera.getPosition().getX(), gameCamera.getPosition().getY());
        camera.setTargetToPosition();
        camera.setScalingPoint(new Point2D.Double(coreEngine.getGameWidth() / 2.0, coreEngine.getGameHeight() / 2.0));
        camera.setSmoothScaleSpeedCoeff(0.1f);
        camera.setScaling(gameCamera.getScaling());
        camera.setTargetScaling(gameCamera.getScaling() * 0.9f);
        coreEngine.getCurrentScene().setCamera(camera);
    }

    private static void swapToGameCamera() {
        if (gameCamera == null) {
            return;
        }
        if (!coreEngine.isEditingPause()) {
            return;
        }
        coreEngine.setBlackBarsColor(new Color(0, 0, 0));
        if (gameCamera.getTranslateMode() != Camera.Mode.INSTANT || gameCamera.getTranslateMode() != Camera.Mode.NO_FOLLOW) {
            gameCamera.setScaling(camera.getScaling());
            gameCamera.setPosition(camera.getPosition().getX(), camera.getPosition().getY());
        }
        coreEngine.getCurrentScene().setCamera(gameCamera);
    }

    public static void setSelectedEntity(SEEntity entity) {
        if (selectedEntity != null) {
            if (entity.getLiveEntity() == selectedEntity.getLiveEntity()) {
                return;
            }
            selectedEntity.setSelected(false);
        }
        selectedEntity = entity;
        entity.setSelected(true);
        SceneEditor.fireSelectedEntityChanged();
    }

    public static void setCurrentScene(SEScene newScene) {
        currentScene = newScene;
    }

    public static void setCurrentScene(String newSceneName) {
        currentScene = seScenes.get(newSceneName);
    }

    public static void updateSeSceneList() {
        for (Scene scene : coreEngine.getScenes().values()) {
            if (seScenes.containsKey(scene.getName())) continue;
            seScenes.put(scene.getName(), new SEScene(scene));
        }
        Iterator<String> it = seScenes.keySet().iterator();
        while (it.hasNext()) {
            if (coreEngine.getScenes().containsKey(it.next())) continue;
            it.remove();
        }
    }

    public static void addGameStateEventListener(GameStateEventListener evtListener) {
        listenerList.add(GameStateEventListener.class, evtListener);
    }

    public static void removeGameStateEventListener(GameStateEventListener evtListener) {
        listenerList.remove(GameStateEventListener.class, evtListener);
    }

    private static void fireGameStateChanged() {
        GameStateEventListener[] gameStateEventListenerArray = (GameStateEventListener[])listenerList.getListeners(GameStateEventListener.class);
        int n = gameStateEventListenerArray.length;
        int n2 = 0;
        while (n2 < n) {
            GameStateEventListener listener = gameStateEventListenerArray[n2];
            listener.gameStateChanged(gameState);
            ++n2;
        }
    }

    public static void addEntityEventListener(EntityEventListener evtListener) {
        listenerList.add(EntityEventListener.class, evtListener);
    }

    public static void removeEntityEventListener(EntityEventListener evtListener) {
        listenerList.remove(EntityEventListener.class, evtListener);
    }

    public static void fireSelectedEntityChanged() {
        EntityEventListener[] entityEventListenerArray = (EntityEventListener[])listenerList.getListeners(EntityEventListener.class);
        int n = entityEventListenerArray.length;
        int n2 = 0;
        while (n2 < n) {
            EntityEventListener listener = entityEventListenerArray[n2];
            listener.changeSelectedEntity(selectedEntity);
            ++n2;
        }
    }

    public static void fireEntityListChanged() {
        EntityEventListener[] entityEventListenerArray = (EntityEventListener[])listenerList.getListeners(EntityEventListener.class);
        int n = entityEventListenerArray.length;
        int n2 = 0;
        while (n2 < n) {
            EntityEventListener listener = entityEventListenerArray[n2];
            listener.entityListChanged(seScenes);
            ++n2;
        }
    }

    public static void addSystemEventListener(SystemEventListener evtListener) {
        listenerList.add(SystemEventListener.class, evtListener);
    }

    public static void removeSystemEventListener(SystemEventListener evtListener) {
        listenerList.remove(SystemEventListener.class, evtListener);
    }

    public static void fireSystemListChanged() {
        SystemEventListener[] systemEventListenerArray = (SystemEventListener[])listenerList.getListeners(SystemEventListener.class);
        int n = systemEventListenerArray.length;
        int n2 = 0;
        while (n2 < n) {
            SystemEventListener listener = systemEventListenerArray[n2];
            listener.systemListChanged();
            ++n2;
        }
    }

    public static Camera getEditingCamera() {
        return camera;
    }

    public static Camera getGameCamera() {
        return gameCamera;
    }

    public static enum EditorState {
        PLAY,
        PAUSE,
        STOP,
        ERROR;

    }
}

