/*
 * Decompiled with CFR 0.152.
 */
package ch.sparkpudding.sceneeditor;

import ch.sparkpudding.coreengine.Scheduler;
import ch.sparkpudding.sceneeditor.SceneEditor;
import ch.sparkpudding.sceneeditor.menu.MenuBar;
import ch.sparkpudding.sceneeditor.panel.PanelEditor;
import ch.sparkpudding.sceneeditor.panel.PanelGame;
import ch.sparkpudding.sceneeditor.panel.PanelSidebarLeft;
import ch.sparkpudding.sceneeditor.panel.PanelSidebarRight;
import ch.sparkpudding.sceneeditor.utils.ImageStorage;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import javax.swing.JFrame;
import javax.swing.JSplitPane;

public class FrameSceneEditor
extends JFrame {
    private final String TITLE = "Live Editor for LEL";
    private final int WIDTH = 1280;
    private final int HEIGHT = 720;
    private MenuBar menuBar;
    private PanelSidebarRight panelSidebarRight;
    private PanelSidebarLeft panelSidebarLeft;
    private PanelGame panelGame;
    private PanelEditor panelEditor;
    private BorderLayout borderLayout;
    private JSplitPane verticalSplitPanel;
    private JSplitPane horizontalSplitPanel;

    public FrameSceneEditor() {
        this.init();
        this.setupFrame();
        this.setupLayout();
        this.addListener();
        this.setVisible(true);
        SceneEditor.coreEngine.getScheduler().schedule(Scheduler.Trigger.GAME_LOOP_START, new Runnable(){

            @Override
            public void run() {
                SceneEditor.setGameState(SceneEditor.EditorState.STOP);
            }
        });
    }

    private void init() {
        this.borderLayout = new BorderLayout();
        this.menuBar = new MenuBar();
        this.panelSidebarRight = new PanelSidebarRight();
        this.panelSidebarLeft = new PanelSidebarLeft();
        this.panelGame = new PanelGame();
        this.panelEditor = new PanelEditor();
    }

    private void setupLayout() {
        this.setLayout(this.borderLayout);
        this.setJMenuBar(this.menuBar);
        this.add((Component)this.panelSidebarLeft, "West");
        this.horizontalSplitPanel = new JSplitPane(0, this.panelGame, this.panelEditor);
        this.verticalSplitPanel = new JSplitPane(1, this.horizontalSplitPanel, this.panelSidebarRight);
        this.add((Component)this.verticalSplitPanel, "Center");
    }

    private void addListener() {
        SceneEditor.coreEngine.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseReleased(MouseEvent e) {
                SceneEditor.coreEngine.requestFocus();
            }
        });
        this.addComponentListener(new ComponentAdapter(){

            @Override
            public void componentResized(ComponentEvent e) {
                FrameSceneEditor.this.verticalSplitPanel.setDividerLocation(e.getComponent().getWidth() - 500);
                FrameSceneEditor.this.horizontalSplitPanel.setDividerLocation(e.getComponent().getHeight() - 400);
            }
        });
    }

    private void setupFrame() {
        this.setSize(1280, 720);
        this.setExtendedState(this.getExtendedState() | 6);
        this.setDefaultCloseOperation(3);
        this.setTitle("Live Editor for LEL");
        this.setIconImage(ImageStorage.ICON.getImage());
        this.setJMenuBar(this.menuBar);
        this.setLocationRelativeTo(null);
    }
}

