/*
 * Decompiled with CFR 0.152.
 */
package ch.sparkpudding.coreengine.ecs.system;

import ch.sparkpudding.coreengine.Lel;
import ch.sparkpudding.coreengine.api.Camera;
import ch.sparkpudding.coreengine.api.Core;
import ch.sparkpudding.coreengine.api.Resource;
import ch.sparkpudding.coreengine.api.Sound;
import ch.sparkpudding.coreengine.ecs.entity.Entity;
import ch.sparkpudding.coreengine.utils.Pair;
import java.io.File;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import org.luaj.vm2.Globals;
import org.luaj.vm2.LoadState;
import org.luaj.vm2.LuaError;
import org.luaj.vm2.LuaTable;
import org.luaj.vm2.LuaValue;
import org.luaj.vm2.Varargs;
import org.luaj.vm2.compiler.LuaC;
import org.luaj.vm2.lib.PackageLib;
import org.luaj.vm2.lib.StringLib;
import org.luaj.vm2.lib.jse.CoerceJavaToLua;
import org.luaj.vm2.lib.jse.JseBaseLib;
import org.luaj.vm2.lib.jse.JseMathLib;

public abstract class System {
    protected String filepath;
    private String name;
    protected Map<String, List<String>> componentGroups;
    private Map<String, List<Entity>> entityGroups;
    protected List<Pair<String, Entity>> sortedEntities;
    protected Map<String, LuaValue> componentGroupsLuaFunctions;
    private LuaValue getRequiredComponentsMethod;
    protected LuaValue apiTable;
    protected Globals globals;
    protected boolean loadingFailed;
    Thread sandboxThread;
    protected ExecutorService executor;
    protected static final int MAX_EXECUTION_TIME_IN_SECONDS = 3;

    public void sortEntities() {
        this.sortedEntities.sort(new Comparator<Pair<String, Entity>>(){

            @Override
            public int compare(Pair<String, Entity> arg0, Pair<String, Entity> arg1) {
                if (arg0.second().getZIndex() > arg1.second().getZIndex()) {
                    return 1;
                }
                if (arg0.second().getZIndex() < arg1.second().getZIndex()) {
                    return -1;
                }
                return arg1.second().getName().compareTo(arg0.second().getName());
            }
        });
    }

    public System(File file) {
        this.filepath = file.getAbsolutePath();
        this.name = file.getName();
        this.executor = Executors.newFixedThreadPool(1);
        this.reload();
    }

    public void reload() {
        this.globals = new Globals();
        this.componentGroups = new HashMap<String, List<String>>();
        this.entityGroups = new HashMap<String, List<Entity>>();
        this.sortedEntities = new ArrayList<Pair<String, Entity>>();
        this.componentGroupsLuaFunctions = new HashMap<String, LuaValue>();
        this.loadingFailed = false;
        this.loadLuaLibs();
        if (!this.loadLuaSystem()) {
            this.loadingFailed = true;
        } else {
            this.readMethodsFromLua();
            this.loadApis();
            this.loadRequiredComponents();
        }
    }

    private void loadApis() {
        this.apiTable = new LuaTable();
        this.globals.set("game", this.apiTable);
        this.apiTable.set("core", CoerceJavaToLua.coerce(Core.getInstance()));
        this.apiTable.set("camera", CoerceJavaToLua.coerce(Camera.getInstance()));
        this.apiTable.set("resources", CoerceJavaToLua.coerce(Resource.getInstance()));
        this.apiTable.set("sound", CoerceJavaToLua.coerce(Sound.getInstance()));
    }

    private void loadLuaLibs() {
        this.globals.load(new JseBaseLib());
        this.globals.load(new PackageLib());
        this.globals.load(new JseMathLib());
        this.globals.load(new StringLib());
        LoadState.install(this.globals);
        LuaC.install(this.globals);
    }

    private boolean loadLuaSystem() {
        try {
            this.globals.get("dofile").call(LuaValue.valueOf(this.filepath));
            return true;
        }
        catch (LuaError error2) {
            Lel.coreEngine.notifyGameError(error2);
        }
        catch (Exception error3) {
            Lel.coreEngine.notifyGameError(error3);
        }
        return false;
    }

    protected void readMethodsFromLua() {
        this.getRequiredComponentsMethod = this.globals.get("getRequiredComponents");
    }

    private void loadRequiredComponents() {
        this.componentGroups.clear();
        this.componentGroupsLuaFunctions.clear();
        LuaTable list = null;
        try {
            list = (LuaTable)this.getRequiredComponentsMethod.call();
        }
        catch (ClassCastException error2) {
            Lel.coreEngine.notifyGameError(new Exception(String.valueOf(this.filepath) + ": could not parse required components."));
            this.loadingFailed = true;
            return;
        }
        catch (LuaError error3) {
            Lel.coreEngine.notifyGameError(new Exception(String.valueOf(this.filepath) + ": missing function getRequiredComponents."));
            this.loadingFailed = true;
            return;
        }
        LuaValue key = LuaValue.NIL;
        Varargs entry = list.next(key);
        if (entry.arg(2).istable()) {
            while (!(key = entry.arg(1)).isnil()) {
                ArrayList<String> components = new ArrayList<String>();
                String groupName = entry.arg(1).tojstring();
                LuaValue innerKey = LuaValue.NIL;
                Varargs innerEntry = entry.arg(2).next(innerKey);
                while (!(innerKey = innerEntry.arg(1)).isnil()) {
                    components.add(innerEntry.arg(2).tojstring());
                    innerEntry = entry.arg(2).next(innerKey);
                }
                this.componentGroups.put(groupName, components);
                entry = list.next(key);
            }
        } else {
            ArrayList<String> components = new ArrayList<String>();
            while (!(key = entry.arg(1)).isnil()) {
                components.add(entry.arg(2).tojstring());
                entry = list.next(key);
            }
            this.componentGroups.put("entities", components);
        }
    }

    public void setEntities(List<Entity> newEntities) {
        this.sortedEntities.clear();
        for (String listName : this.componentGroups.keySet()) {
            this.setEntityList(newEntities, listName);
            this.addEntityGroupToGlobals(listName);
        }
    }

    private void setEntityList(List<Entity> newEntities, String listName) {
        List<String> componentList = this.componentGroups.get(listName);
        ArrayList<Entity> entities = new ArrayList<Entity>();
        for (Entity entity : newEntities) {
            if (!entity.hasComponents(componentList)) continue;
            entities.add(entity);
            this.sortedEntities.add(new Pair<String, Entity>(listName, entity));
        }
        this.entityGroups.put(listName, entities);
        this.sortEntities();
    }

    private void addEntityGroupToGlobals(String listName) {
        List<Entity> entities = this.entityGroups.get(listName);
        LuaTable entitiesTableLua = new LuaTable();
        int i = 0;
        while (i < entities.size()) {
            entitiesTableLua.set(i + 1, (LuaValue)entities.get(i).getLuaEntity());
            ++i;
        }
        this.globals.set(listName, (LuaValue)entitiesTableLua);
    }

    public void tryAdd(Entity entity) {
        for (Map.Entry<String, List<String>> componentList : this.componentGroups.entrySet()) {
            if (!entity.hasComponents(componentList.getValue())) continue;
            this.entityGroups.get(componentList.getKey()).add(entity);
            this.sortedEntities.add(new Pair<String, Entity>(componentList.getKey(), entity));
            LuaTable entityGroup = (LuaTable)this.globals.get(componentList.getKey());
            entityGroup.set(entityGroup.keyCount() + 1, (LuaValue)entity.getLuaEntity());
        }
        this.sortEntities();
    }

    public void tryRemove(Entity entity) {
        block0: for (Map.Entry<String, List<Entity>> entityList : this.entityGroups.entrySet()) {
            List<Entity> entities = entityList.getValue();
            int i = 0;
            while (i < entities.size()) {
                if (entities.get(i) == entity) {
                    entities.remove(i);
                    this.addEntityGroupToGlobals(entityList.getKey());
                    continue block0;
                }
                ++i;
            }
        }
        int i = 0;
        while (i < this.sortedEntities.size()) {
            Pair<String, Entity> entityPair = this.sortedEntities.get(i);
            if (entityPair.second() == entity) {
                this.sortedEntities.remove(i);
                --i;
            }
            ++i;
        }
    }

    public void notifyRemovedComponent(Entity entity, String componentName) {
        for (Map.Entry<String, List<Entity>> entityList : this.entityGroups.entrySet()) {
            if (!this.componentGroups.get(entityList.getKey()).contains(componentName)) continue;
            entityList.getValue().remove(entity);
            this.addEntityGroupToGlobals(entityList.getKey());
        }
        int i = 0;
        while (i < this.sortedEntities.size()) {
            Pair<String, Entity> entityPair = this.sortedEntities.get(i);
            if (entity == entityPair.second() && this.componentGroups.get(entityPair.first()).contains(componentName)) {
                this.sortedEntities.remove(i);
                --i;
            }
            ++i;
        }
    }

    public void notifyNewComponent(Entity entity, String componentName) {
        for (String listName : this.entityGroups.keySet()) {
            List<String> componentList = this.componentGroups.get(listName);
            if (!componentList.contains(componentName) || !entity.hasComponents(this.componentGroups.get(listName))) continue;
            this.entityGroups.get(listName).add(entity);
            this.sortedEntities.add(new Pair<String, Entity>(listName, entity));
            this.addEntityGroupToGlobals(listName);
            this.sortEntities();
        }
    }

    public String getFilepath() {
        return this.filepath;
    }

    public String getName() {
        return this.name;
    }

    public Map<String, List<String>> getComponentGroups() {
        return this.componentGroups;
    }
}

