/*
 * Decompiled with CFR 0.152.
 */
package ch.sparkpudding.coreengine.ecs.system;

import ch.sparkpudding.coreengine.Lel;
import ch.sparkpudding.coreengine.api.ColorFactory;
import ch.sparkpudding.coreengine.api.Graphics;
import ch.sparkpudding.coreengine.api.Input;
import ch.sparkpudding.coreengine.ecs.entity.Entity;
import ch.sparkpudding.coreengine.ecs.system.System;
import ch.sparkpudding.coreengine.utils.Pair;
import java.awt.Graphics2D;
import java.io.File;
import java.util.Map;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.luaj.vm2.LuaError;
import org.luaj.vm2.LuaValue;
import org.luaj.vm2.lib.jse.CoerceJavaToLua;

public class RenderSystem
extends System {
    public static final String LUA_FILE_NAME = "render.lua";
    private LuaValue renderStartMethod;
    private LuaValue renderEndMethod;

    public RenderSystem(File file) {
        super(file);
        this.reload();
    }

    @Override
    protected void readMethodsFromLua() {
        super.readMethodsFromLua();
        this.renderStartMethod = this.globals.get("renderStart");
        this.renderEndMethod = this.globals.get("renderEnd");
        if (this.renderStartMethod.isnil() || this.renderEndMethod.isnil()) {
            Lel.coreEngine.notifyGameError(new Exception("renderStart or renderEnd function missing in " + this.filepath));
        }
    }

    @Override
    public void reload() {
        super.reload();
        if (!this.loadingFailed) {
            this.readMethodsFromLua();
            this.loadRenderApis();
            for (Map.Entry entry : this.componentGroups.entrySet()) {
                LuaValue func = this.globals.get("render" + ((String)entry.getKey()).substring(0, 1).toUpperCase() + ((String)entry.getKey()).substring(1));
                if (func == LuaValue.NIL) continue;
                this.componentGroupsLuaFunctions.put((String)entry.getKey(), func);
            }
        }
    }

    private void loadRenderApis() {
        this.apiTable.set("color", CoerceJavaToLua.coerce(ColorFactory.getInstance()));
        this.globals.set("g", CoerceJavaToLua.coerce(Graphics.getInstance()));
        this.apiTable.set("input", CoerceJavaToLua.coerce(Input.getInstance()));
    }

    public void render(Graphics2D g) {
        if (!this.loadingFailed) {
            Future<?> future = this.executor.submit(() -> this.sandboxedRender(g));
            try {
                future.get(3L, TimeUnit.SECONDS);
            }
            catch (InterruptedException e) {
                Lel.coreEngine.notifyGameError(new Exception("A LEL internal error occured."));
            }
            catch (ExecutionException e) {
                Lel.coreEngine.notifyGameError(new Exception("A LEL internal error occured."));
            }
            catch (TimeoutException e) {
                this.loadingFailed = true;
                future.cancel(true);
                Lel.coreEngine.notifyGameError(new Exception(String.valueOf(this.filepath) + " took more than the " + 3 + " seconds allowed to render."));
            }
        }
    }

    private void sandboxedRender(Graphics2D g) {
        try {
            Graphics.getInstance().setGraphicalContext(g);
            this.renderStartMethod.call();
            int i = 0;
            while (i < this.sortedEntities.size()) {
                LuaValue func = (LuaValue)this.componentGroupsLuaFunctions.get(((Pair)this.sortedEntities.get(i)).first());
                if (func != null) {
                    func.call(((Entity)((Pair)this.sortedEntities.get(i)).second()).getLuaEntity());
                }
                ++i;
            }
            this.renderEndMethod.call();
            Graphics.getInstance().dispose();
        }
        catch (LuaError error2) {
            Lel.coreEngine.notifyGameError(error2);
        }
        catch (StackOverflowError error3) {
            Lel.coreEngine.notifyGameError(new Exception("Stack overflow in " + this.filepath + ". This sometimes happens when trying to read an inexisting field from a component."));
        }
    }
}

