/*
 * Decompiled with CFR 0.152.
 */
package ch.sparkpudding.coreengine.ecs.entity;

import ch.sparkpudding.coreengine.Camera;
import ch.sparkpudding.coreengine.ecs.entity.Entity;
import java.util.ArrayList;
import java.util.List;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class Scene {
    private List<Entity> entities;
    private List<Entity> defaultEntities;
    private String name;
    private Camera camera;
    private int tick;

    public Scene() {
        this.name = "DEFAULT NAME";
        this.entities = new ArrayList<Entity>();
        this.defaultEntities = new ArrayList<Entity>();
        this.camera = new Camera();
        this.tick = 0;
    }

    public Scene(String name) {
        this();
        this.name = name;
    }

    public Scene(Document document) {
        Element sceneElement = document.getDocumentElement();
        this.name = sceneElement.getAttribute("name");
        this.tick = 0;
        this.entities = new ArrayList<Entity>();
        this.defaultEntities = new ArrayList<Entity>();
        NodeList entities = sceneElement.getChildNodes();
        int i = 0;
        while (i < entities.getLength()) {
            Node node = entities.item(i);
            if (node.getNodeType() == 1) {
                Element entityElement = (Element)entities.item(i);
                this.addEntity(new Entity(entityElement));
                this.addDefault(new Entity(entityElement));
            }
            ++i;
        }
        this.camera = new Camera();
    }

    public void addEntity(Entity e) {
        this.entities.add(e);
    }

    public void addDefault(Entity e) {
        this.defaultEntities.add(e);
    }

    public void reset(boolean useDirectlyDefaultEntities) {
        this.entities.clear();
        this.tick = 0;
        if (useDirectlyDefaultEntities) {
            for (Entity entity : this.defaultEntities) {
                this.entities.add(entity);
            }
        } else {
            for (Entity entity : this.defaultEntities) {
                this.entities.add(new Entity(entity));
            }
        }
    }

    public List<Entity> getEntities() {
        return this.entities;
    }

    public List<Entity> getDefaultEntities() {
        return this.defaultEntities;
    }

    public void removeEntity(Entity e) {
        this.entities.remove(e);
    }

    public void removeDefaultEntity(Entity e) {
        this.defaultEntities.remove(e);
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public boolean isStartScene() {
        return this.name.equals("main");
    }

    public Camera getCamera() {
        return this.camera;
    }

    public void incrementTick() {
        ++this.tick;
    }

    public int getTick() {
        return this.tick;
    }

    public void setCamera(Camera camera) {
        this.camera = camera;
    }
}

