/*
 * Decompiled with CFR 0.152.
 */
package ch.sparkpudding.coreengine.ecs.entity;

import ch.sparkpudding.coreengine.Lel;
import ch.sparkpudding.coreengine.Scheduler;
import ch.sparkpudding.coreengine.api.MetaEntity;
import ch.sparkpudding.coreengine.ecs.component.Component;
import ch.sparkpudding.coreengine.utils.Pair;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.luaj.vm2.LuaTable;
import org.luaj.vm2.lib.jse.CoerceJavaToLua;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class Entity
implements Iterable<Map.Entry<String, Component>> {
    private static Map<String, Entity> templates = new HashMap<String, Entity>();
    private Map<String, Component> components;
    private String name;
    private String template;
    private int zIndex;
    private LuaTable luaEntity;

    public Entity() {
        this("", "", 0, new HashMap<String, Component>());
    }

    public Entity(String name, String template, int zIndex, HashMap<String, Component> components) {
        this.name = name;
        this.template = template;
        this.setZIndex(zIndex);
        this.components = components;
        this.createLuaEntity();
    }

    public Entity(Entity entity) {
        this(entity.name, entity.template, entity.zIndex, new HashMap<String, Component>());
        this.components = new HashMap<String, Component>();
        for (Component component : entity.getComponents().values()) {
            if (component.getName().startsWith("se-")) continue;
            this.components.put(component.getName(), new Component(component));
        }
        this.createLuaEntity();
    }

    public Entity(Document document) {
        Element entityElement = document.getDocumentElement();
        this.template = this.name = entityElement.getAttribute("name");
        String zindex = entityElement.getAttribute("z-index");
        if (zindex.length() > 0) {
            this.setZIndex(Integer.parseInt(zindex));
        } else {
            this.setZIndex(0);
        }
        this.components = new HashMap<String, Component>();
        NodeList componentsXML = entityElement.getChildNodes();
        int i = 0;
        while (i < componentsXML.getLength()) {
            Node node = componentsXML.item(i);
            if (node.getNodeType() == 1) {
                Element componentElement = (Element)componentsXML.item(i);
                this.addComponent(new Component(componentElement));
            }
            ++i;
        }
    }

    public Entity(Element element) {
        this(templates.getOrDefault(element.getAttribute("template"), new Entity()));
        this.name = element.getAttribute("name");
        this.template = element.getAttribute("template");
        this.zIndex = Integer.parseInt(element.getAttribute("z-index"));
        NodeList components = element.getChildNodes();
        int i = 0;
        while (i < components.getLength()) {
            Node node = components.item(i);
            if (node.getNodeType() == 1) {
                Element componentElement = (Element)components.item(i);
                if (componentElement.hasAttribute("deleted")) {
                    this.removeComponent(componentElement.getAttribute("template"));
                } else {
                    this.removeComponent(componentElement.getAttribute("template"));
                    this.addComponent(new Component(componentElement));
                }
            }
            ++i;
        }
        this.createLuaEntity();
    }

    private void createLuaEntity() {
        this.luaEntity = this.coerceToLua();
    }

    public void addComponent(Component c) {
        this.components.put(c.getName(), c);
        Lel.coreEngine.getScheduler().trigger(Scheduler.Trigger.COMPONENT_ADDED, new Pair<Entity, Component>(this, c));
        this.createLuaEntity();
    }

    public boolean addComponent(String componentName) {
        Component component = Component.getTemplates().get(componentName);
        if (component != null && !this.components.containsKey(componentName)) {
            this.addComponent(component);
            this.createLuaEntity();
            Lel.coreEngine.getScheduler().trigger(Scheduler.Trigger.COMPONENT_ADDED, new Pair<Entity, Component>(this, component));
            return true;
        }
        return false;
    }

    public boolean removeComponent(String name) {
        if (this.components.containsKey(name)) {
            this.components.remove(name);
            this.createLuaEntity();
            return true;
        }
        return false;
    }

    public String getName() {
        return this.name;
    }

    public int getZIndex() {
        return this.zIndex;
    }

    public void setComponentAttached(String componentName, boolean attached) {
        this.components.get(componentName).setAttached(attached, true);
        if (attached && templates.get(this.template).getComponents().get(componentName) != null) {
            Component nc = new Component(templates.get(this.template).getComponents().get(componentName));
            this.components.put(componentName, nc);
        }
    }

    public void setZIndex(int zIndex) {
        this.zIndex = zIndex;
    }

    public void setName(String name) {
        this.name = name;
    }

    public Map<String, Component> getComponents() {
        return this.components;
    }

    @Override
    public Iterator<Map.Entry<String, Component>> iterator() {
        return this.components.entrySet().iterator();
    }

    public static Map<String, Entity> getTemplates() {
        return templates;
    }

    public static void setTemplates(Map<String, Entity> templates) {
        Entity.templates = templates;
    }

    public static void addTemplate(Entity template) {
        Entity newTemplate = new Entity(template);
        for (Map.Entry<String, Component> componentEntry : newTemplate.getComponents().entrySet()) {
            componentEntry.getValue().setAttached(true, false);
        }
        templates.put(template.getTemplate(), newTemplate);
    }

    public String getTemplate() {
        return this.template;
    }

    public void setTemplate(String template) {
        this.template = template;
    }

    public boolean hasComponents(List<String> componentNames) {
        return this.components.keySet().containsAll(componentNames);
    }

    private LuaTable coerceToLua() {
        LuaTable entityLua = new LuaTable();
        for (Component component : this.getComponents().values()) {
            entityLua.set(component.getName(), component.coerceToLua());
        }
        entityLua.set("_meta", CoerceJavaToLua.coerce(new MetaEntity(this)));
        return entityLua;
    }

    public LuaTable getLuaEntity() {
        return this.luaEntity;
    }

    public boolean hasComponent(String componentName) {
        return this.components.keySet().contains(componentName);
    }
}

