/*
 * Decompiled with CFR 0.152.
 */
package ch.sparkpudding.coreengine.ecs.component;

import ch.sparkpudding.coreengine.ecs.component.Field;
import ch.sparkpudding.coreengine.utils.Lua;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.luaj.vm2.LuaTable;
import org.luaj.vm2.LuaValue;
import org.luaj.vm2.lib.jse.CoerceJavaToLua;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class Component
implements Iterable<Map.Entry<String, Field>> {
    private static Map<String, Component> templates = new HashMap<String, Component>();
    private String name;
    private String templateName;
    private Map<String, Field> fields;
    private boolean attached;

    public Component(String name, String template) {
        this.attached = true;
        this.name = name;
        this.templateName = template;
        this.fields = new HashMap<String, Field>();
    }

    public Component(String name, Map<String, Field> fields) {
        this.attached = true;
        this.name = name;
        this.fields = fields;
        this.templateName = name;
    }

    public Component(Component component) {
        this.attached = component.attached;
        this.name = component.name;
        this.templateName = component.templateName;
        this.fields = new HashMap<String, Field>();
        for (Field field : component.fields.values()) {
            this.addField(new Field(field));
        }
    }

    public Component(Document document) {
        this.attached = true;
        this.fields = new HashMap<String, Field>();
        this.templateName = this.name = document.getDocumentElement().getAttribute("name");
        NodeList fields = document.getDocumentElement().getChildNodes();
        int i = 0;
        while (i < fields.getLength()) {
            Node node = fields.item(i);
            if (node.getNodeType() == 1) {
                this.attached = false;
                Element fieldElement = (Element)fields.item(i);
                this.fields.put(fieldElement.getAttribute("name"), new Field(fieldElement.getAttribute("name"), fieldElement.getAttribute("type"), fieldElement.getTextContent()));
            }
            ++i;
        }
    }

    public Component(Element element) {
        this(templates.get(element.getAttribute("template")));
        this.templateName = element.getAttribute("template");
        NodeList fields = element.getChildNodes();
        this.attached = true;
        int i = 0;
        while (i < fields.getLength()) {
            Node node = fields.item(i);
            if (node.getNodeType() == 1) {
                this.attached = false;
                Element fieldElement = (Element)fields.item(i);
                this.fields.get(fieldElement.getAttribute("name")).setValueFromString(fieldElement.getTextContent());
            }
            ++i;
        }
    }

    public void addField(Field field) {
        this.fields.put(field.getName(), field);
    }

    public Field getField(String name) {
        return this.fields.get(name);
    }

    public Map<String, Field> getFields() {
        return this.fields;
    }

    @Override
    public Iterator<Map.Entry<String, Field>> iterator() {
        return this.fields.entrySet().iterator();
    }

    public String getName() {
        return this.name;
    }

    public static Map<String, Component> getTemplates() {
        return templates;
    }

    public static void addTemplate(Component template) {
        templates.put(template.getName(), template);
    }

    public String getTemplateName() {
        return this.templateName;
    }

    public LuaValue coerceToLua() {
        LuaTable componentLua = new LuaTable();
        LuaValue metatableSetterMethod = Lua.getMetatableSetterMethod();
        for (Field field : this.getFields().values()) {
            LuaValue fieldLua = CoerceJavaToLua.coerce(field);
            componentLua.set("_" + field.getName(), fieldLua);
        }
        metatableSetterMethod.call(componentLua);
        return componentLua;
    }

    public boolean isAttached() {
        return this.attached;
    }

    public void setAttached(boolean attached, boolean reset) {
        this.attached = attached;
        if (attached && reset) {
            for (Field field : this.fields.values()) {
                field.setValue(templates.get(this.templateName).getField(field.getName()).getValue());
            }
        }
    }
}

