/*
 * Decompiled with CFR 0.152.
 */
package ch.sparkpudding.coreengine.api;

import ch.sparkpudding.coreengine.Lel;
import ch.sparkpudding.coreengine.Scheduler;
import ch.sparkpudding.coreengine.ecs.entity.Entity;
import org.luaj.vm2.LuaValue;

public class Core {
    private static Core instance;

    private Core() {
    }

    public static Core getInstance() {
        if (instance == null) {
            instance = new Core();
        }
        return instance;
    }

    public int getTick() {
        return Lel.coreEngine.getCurrentScene().getTick();
    }

    public int getEditingTick() {
        return Lel.coreEngine.getEditingTick();
    }

    public double getGameWidth() {
        return Lel.coreEngine.getGameWidth();
    }

    public double getGameHeight() {
        return Lel.coreEngine.getGameHeight();
    }

    public int getFPS() {
        return Lel.coreEngine.getFPS();
    }

    public void setScene(String name) {
        this.setScene(name, false);
    }

    public void setScene(final String name, final boolean reset) {
        if (!Lel.coreEngine.getScenes().containsKey(name)) {
            Lel.coreEngine.notifyGameError(new Exception("Scene not found: " + name));
            return;
        }
        Lel.coreEngine.getScheduler().schedule(Scheduler.Trigger.GAME_LOOP_START, new Runnable(){

            @Override
            public void run() {
                Lel.coreEngine.setScene(name, reset, false);
            }
        });
    }

    public void setPause(boolean isPause) {
        Lel.coreEngine.setPause(isPause);
    }

    public void resetScene() {
        this.setScene(Lel.coreEngine.getCurrentScene().getName(), true);
    }

    public LuaValue createEntity(String templateName) {
        final Entity e = new Entity(Entity.getTemplates().get(templateName));
        Lel.coreEngine.getScheduler().schedule(Scheduler.Trigger.GAME_LOOP_START, new Runnable(){

            @Override
            public void run() {
                Lel.coreEngine.addEntity(e);
            }
        });
        return e.getLuaEntity();
    }
}

