/*
 * Decompiled with CFR 0.152.
 */
package ch.sparkpudding.coreengine.api;

import ch.sparkpudding.coreengine.Camera;
import ch.sparkpudding.coreengine.Lel;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.geom.Point2D;

public class Camera {
    private static Camera instance;

    public static Camera getInstance() {
        if (instance == null) {
            instance = new Camera();
        }
        return instance;
    }

    private Camera() {
    }

    public void applyTransforms(Graphics2D g2d) {
        Lel.coreEngine.getCamera().applyTransforms(g2d);
    }

    public void resetTransforms(Graphics2D g2d) {
        Lel.coreEngine.getCamera().resetTransforms(g2d);
    }

    public void setPosition(float x, float y) {
        Lel.coreEngine.getCamera().setWorldPosition(x, y);
    }

    public void setTargetScaling(float s) {
        Lel.coreEngine.getCamera().setTargetScaling(s);
    }

    public void setTargetToPosition() {
        Lel.coreEngine.getCamera().setTargetToPosition();
    }

    public void centerTargetAt(float x, float y, float w, float h) {
        Lel.coreEngine.getCamera().centerTargetAt(x, y, w, h);
    }

    public void centerAt(float x, float y, float w, float h) {
        Lel.coreEngine.getCamera().centerAt(x, y, w, h);
    }

    public void centerAt(float x, float y) {
        this.centerAt(x, y, 0.0f, 0.0f);
    }

    public void centerTargetAt(float x, float y) {
        this.centerTargetAt(x, y, 0.0f, 0.0f);
    }

    public void setTargetPosition(float x, float y) {
        Lel.coreEngine.getCamera().setTargetPosition(x, y);
    }

    public void setMode(String mode) {
        Lel.coreEngine.getCamera().setTranslateMode(Camera.Mode.valueOf(mode));
    }

    public void clearBoundary() {
        Lel.coreEngine.getCamera().setBoundary(null);
    }

    public void setBoundary(float x, float y, float w, float h) {
        Lel.coreEngine.getCamera().setBoundary(new Rectangle((int)x, (int)y, (int)w, (int)h));
    }

    public void setSpringTranslateForce(float x, float y) {
        Lel.coreEngine.getCamera().setSpringTranslateForce(new Point2D.Double(x, y));
    }

    public void setSpringTranslateConstant(float x, float y) {
        Lel.coreEngine.getCamera().setSpringTranslateConstant(new Point2D.Double(x, y));
    }

    public void setSpringTranslateSpeedCoeff(float x, float y) {
        Lel.coreEngine.getCamera().setSpringTranslateSpeedCoeff(new Point2D.Double(x, y));
    }

    public void setSmoothSpeedCoeff(float x, float y) {
        Lel.coreEngine.getCamera().setSmoothSpeedCoeff(new Point2D.Double(x, y));
    }

    public void setLinearSpeedDelta(float x, float y) {
        Lel.coreEngine.getCamera().setLinearSpeedDelta(new Point2D.Double(x, y));
    }

    public void setSmoothScaleSpeedCoeff(float smoothScaleSpeedCoeff) {
        Lel.coreEngine.getCamera().setSmoothScaleSpeedCoeff(smoothScaleSpeedCoeff);
    }

    public void setScalingPoint(double x, double y) {
        Lel.coreEngine.getCamera().setScalingPoint(new Point2D.Double(x, y));
    }

    public void shake(float intensity, int duration) {
        Lel.coreEngine.getCamera().shake(intensity, duration);
    }

    public boolean isInView(float x, float y, float width, float height) {
        return Lel.coreEngine.getCamera().isInView(x, y, width, height);
    }

    public double getX() {
        return Lel.coreEngine.getCamera().getPosition().getX();
    }

    public double getY() {
        return Lel.coreEngine.getCamera().getPosition().getY();
    }

    public float getScaling() {
        return Lel.coreEngine.getCamera().getScaling();
    }

    public boolean isAtTargetScaling() {
        return (double)Math.abs(Lel.coreEngine.getCamera().getScaling() - Lel.coreEngine.getCamera().getTargetScaling()) < 1.0E-4;
    }
}

