/*
 * Decompiled with CFR 0.152.
 */
package ch.sparkpudding.coreengine;

import ch.sparkpudding.coreengine.utils.RunnableOneParameter;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Semaphore;

public class Scheduler {
    private Map<Trigger, List<Runnable>> tasks = new HashMap<Trigger, List<Runnable>>();
    private Map<Trigger, List<Runnable>> notifications;
    private Semaphore semaphore = new Semaphore(1);

    public Scheduler() {
        Trigger trig;
        Trigger[] triggerArray = Trigger.values();
        int n = triggerArray.length;
        int n2 = 0;
        while (n2 < n) {
            trig = triggerArray[n2];
            this.tasks.put(trig, new ArrayList());
            ++n2;
        }
        this.notifications = new HashMap<Trigger, List<Runnable>>();
        triggerArray = Trigger.values();
        n = triggerArray.length;
        n2 = 0;
        while (n2 < n) {
            trig = triggerArray[n2];
            this.notifications.put(trig, new ArrayList());
            ++n2;
        }
    }

    public void trigger(Trigger trigger) {
        this.trigger(trigger, null);
    }

    public void trigger(Trigger trigger, Object object) {
        ArrayList<Runnable> taskCopy = new ArrayList<Runnable>();
        try {
            this.semaphore.acquire();
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
        for (Runnable task : this.tasks.get((Object)trigger)) {
            if (object != null && task instanceof RunnableOneParameter) {
                ((RunnableOneParameter)task).setObject(object);
            }
            taskCopy.add(task);
        }
        for (Runnable task : this.notifications.get((Object)trigger)) {
            if (object != null && task instanceof RunnableOneParameter) {
                ((RunnableOneParameter)task).setObject(object);
            }
            taskCopy.add(task);
        }
        this.tasks.get((Object)trigger).clear();
        this.semaphore.release();
        for (Runnable task : taskCopy) {
            task.run();
        }
    }

    public void schedule(Trigger trigger, Runnable runnable) {
        try {
            this.semaphore.acquire();
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
        this.tasks.get((Object)trigger).add(runnable);
        this.semaphore.release();
    }

    public void notify(Trigger trigger, Runnable runnable) {
        try {
            this.semaphore.acquire();
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
        this.notifications.get((Object)trigger).add(runnable);
        this.semaphore.release();
    }

    public void removeNotify(Trigger trigger, Runnable runnable) {
        try {
            this.semaphore.acquire();
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
        this.notifications.get((Object)trigger).remove(runnable);
        this.semaphore.release();
    }

    public static enum Trigger {
        BEFORE_UPDATE,
        GAME_LOOP_START,
        COMPONENT_ADDED,
        EDITING_STATE_CHANGED,
        SCENE_CHANGED,
        SCENE_LIST_CHANGED;

    }
}

