/*
 * Decompiled with CFR 0.152.
 */
package ch.sparkpudding.coreengine;

import java.awt.Point;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionAdapter;
import java.awt.event.MouseWheelEvent;
import java.awt.event.MouseWheelListener;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.swing.JPanel;

public class Input {
    private List<Integer> keysPressed;
    private List<Integer> keysReleased;
    private List<Integer> mouseButtonsPressed;
    private List<Integer> mouseButtonsReleased;
    private Point mousePositionBuffer;
    private boolean mouseClickedBuffer = false;
    private double mouseWheelRotationBuffer;
    private Map<Integer, Boolean> keys;
    private Map<Integer, Boolean> mouseButtons;
    private Point mousePosition;
    private Point mouseClickedPosition;
    private Point mouseSpeed;
    private boolean mouseClicked = false;
    private double mouseWheelRotation;
    private JPanel panel;

    public Input(JPanel panel) {
        this.panel = panel;
        this.panel.setFocusable(true);
        this.addListeners();
        this.keysPressed = new ArrayList<Integer>();
        this.keysReleased = new ArrayList<Integer>();
        this.mouseButtonsPressed = new ArrayList<Integer>();
        this.mouseButtonsReleased = new ArrayList<Integer>();
        this.mousePositionBuffer = new Point();
        this.mouseClickedPosition = new Point();
        this.mouseWheelRotationBuffer = 0.0;
        this.keys = new HashMap<Integer, Boolean>();
        this.mouseButtons = new HashMap<Integer, Boolean>();
        this.mousePosition = new Point();
        this.mouseWheelRotation = 0.0;
        panel.setFocusable(true);
    }

    public void update() {
        for (Integer key : this.keysPressed) {
            this.keys.put(key, true);
        }
        this.keysPressed.clear();
        for (Integer key : this.keysReleased) {
            this.keys.put(key, false);
        }
        this.keysReleased.clear();
        for (Integer key : this.mouseButtonsPressed) {
            this.mouseButtons.put(key, true);
        }
        if (this.mouseButtonsPressed.size() > 0) {
            this.mouseClickedPosition = this.mousePositionBuffer;
        }
        this.mouseButtonsPressed.clear();
        for (Integer key : this.mouseButtonsReleased) {
            this.mouseButtons.put(key, false);
        }
        this.mouseButtonsReleased.clear();
        this.mouseSpeed = new Point(this.mousePositionBuffer.x - this.mousePosition.x, this.mousePositionBuffer.y - this.mousePosition.y);
        this.mousePosition = this.mousePositionBuffer;
        this.mouseClicked = this.mouseClickedBuffer;
        this.mouseClickedBuffer = false;
        this.mouseWheelRotation = this.mouseWheelRotationBuffer;
        this.mouseWheelRotationBuffer = 0.0;
    }

    public void resetAllKeys() {
        this.keys.clear();
        this.mouseButtons.clear();
        this.keysPressed.clear();
        this.keysReleased.clear();
        this.mouseButtonsPressed.clear();
    }

    public void addListeners() {
        this.panel.addKeyListener(new KeyAdapter(){

            @Override
            public void keyReleased(KeyEvent e) {
                Input.this.keys.put(e.getKeyCode(), false);
            }

            @Override
            public void keyPressed(KeyEvent e) {
                Input.this.keys.put(e.getKeyCode(), true);
            }
        });
        this.panel.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseReleased(MouseEvent e) {
                Input.this.mouseButtonsReleased.add(e.getButton());
            }

            @Override
            public void mousePressed(MouseEvent e) {
                Input.this.mouseButtonsPressed.add(e.getButton());
            }

            @Override
            public void mouseClicked(MouseEvent e) {
                Input.this.mouseClickedBuffer = true;
            }
        });
        this.panel.addMouseMotionListener(new MouseMotionAdapter(){

            @Override
            public void mouseMoved(MouseEvent e) {
                Input.this.mousePositionBuffer = e.getPoint();
            }

            @Override
            public void mouseDragged(MouseEvent e) {
                this.mouseMoved(e);
            }
        });
        this.panel.addMouseWheelListener(new MouseWheelListener(){

            @Override
            public void mouseWheelMoved(MouseWheelEvent e) {
                Input.this.mouseWheelRotationBuffer = e.getPreciseWheelRotation();
            }
        });
    }

    public boolean isKeyDown(int keyCode) {
        return this.keys.getOrDefault(keyCode, false);
    }

    public boolean isMouseButtonDown(int keyCode) {
        return this.mouseButtons.getOrDefault(keyCode, false);
    }

    public boolean isMouseClicked() {
        return this.mouseClicked;
    }

    public Point getMousePosition() {
        return this.mousePosition;
    }

    public Point getMouseSpeed() {
        return this.mouseSpeed;
    }

    public double getMouseWheelRotation() {
        return this.mouseWheelRotation;
    }

    public Point getMouseClickedPosition() {
        return this.mouseClickedPosition;
    }
}

