/*
 * Decompiled with CFR 0.152.
 */
package ch.sparkpudding.coreengine.filereader;

import ch.sparkpudding.coreengine.Lel;
import java.io.File;
import java.io.FileNotFoundException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class LelReader {
    private String directory;
    private Map<String, File> mapComponents;
    private Map<String, File> mapScenes;
    private Map<String, File> mapEntityTemplates;
    private List<File> listSystems;
    private Map<String, File> mapSounds;
    private Map<String, File> mapMusic;
    private Map<String, File> mapTextures;
    private List<File> listEditingSystems;
    private Map<String, File> mapEditingComponents;
    final String[] requiredSubFolders = new String[]{"components", "assets/textures", "assets/sounds", "assets/music", "scenes", "entitytemplates", "systems"};

    public LelReader(String directory) throws Exception {
        this.directory = directory;
        if (!this.isValidLel()) {
            throw new FileNotFoundException();
        }
        this.mapComponents = new HashMap<String, File>();
        this.populateMaps(new File(String.valueOf(directory) + "/components"), this.mapComponents);
        this.mapScenes = new HashMap<String, File>();
        this.populateMaps(new File(String.valueOf(directory) + "/scenes"), this.mapScenes);
        this.mapEntityTemplates = new HashMap<String, File>();
        this.populateMaps(new File(String.valueOf(directory) + "/entitytemplates"), this.mapEntityTemplates);
        this.listSystems = new ArrayList<File>();
        this.populateList(new File(String.valueOf(directory) + "/systems"), this.listSystems);
        this.mapSounds = new HashMap<String, File>();
        this.populateMaps(new File(String.valueOf(directory) + "/assets/sounds"), this.mapSounds);
        this.mapMusic = new HashMap<String, File>();
        this.populateMaps(new File(String.valueOf(directory) + "/assets/music"), this.mapMusic);
        this.mapTextures = new HashMap<String, File>();
        this.populateMaps(new File(String.valueOf(directory) + "/assets/textures"), this.mapTextures);
    }

    private void sortSystem(List<File> list) {
        list.sort(new Comparator<File>(){

            @Override
            public int compare(File o1, File o2) {
                return o1.getName().compareTo(o2.getName());
            }
        });
    }

    public void loadEditingTools(String directory) {
        this.mapEditingComponents = new HashMap<String, File>();
        this.populateMaps(new File(String.valueOf(directory) + "/components"), this.mapEditingComponents);
        this.listEditingSystems = new ArrayList<File>();
        this.populateList(new File(String.valueOf(directory) + "/systems"), this.listEditingSystems);
    }

    private void populateList(File folder, List<File> list) {
        list.clear();
        try {
            File[] fileArray = folder.listFiles();
            int n = fileArray.length;
            int n2 = 0;
            while (n2 < n) {
                File file = fileArray[n2];
                if (file.isDirectory()) {
                    this.populateList(file, list);
                } else {
                    list.add(file);
                }
                ++n2;
            }
        }
        catch (NullPointerException e) {
            Lel.coreEngine.notifyErrorAndClose("Missing folder " + folder);
        }
        this.sortSystem(this.listSystems);
    }

    private void populateMaps(File folder, Map<String, File> map) {
        map.clear();
        try {
            File[] fileArray = folder.listFiles();
            int n = fileArray.length;
            int n2 = 0;
            while (n2 < n) {
                File file = fileArray[n2];
                if (file.isDirectory()) {
                    this.populateMaps(file, map);
                } else {
                    map.put(file.getAbsolutePath(), file);
                }
                ++n2;
            }
        }
        catch (NullPointerException e) {
            Lel.coreEngine.notifyErrorAndClose("Missing folder " + folder);
        }
    }

    private boolean isValidLel() {
        return new File(String.valueOf(this.directory) + "/metadata.xml").exists();
    }

    public Collection<File> getComponentsXML() {
        return this.mapComponents.values();
    }

    public Collection<File> getEditingComponentsXML() {
        return this.mapEditingComponents.values();
    }

    public Collection<File> getScenesXML() {
        return this.mapScenes.values();
    }

    public Collection<File> getEntityTemplatesXML() {
        return this.mapEntityTemplates.values();
    }

    public Collection<File> getTextures() {
        return this.mapTextures.values();
    }

    public Collection<File> getMusics() {
        return this.mapMusic.values();
    }

    public Collection<File> getSounds() {
        return this.mapSounds.values();
    }

    public Collection<File> getSystems() {
        this.populateList(new File(String.valueOf(this.directory) + "/systems"), this.listSystems);
        return this.listSystems;
    }

    public Collection<File> getEditingSystems() {
        return this.listEditingSystems;
    }

    public String getDirectory() {
        return this.directory;
    }
}

