/*
 * Decompiled with CFR 0.152.
 */
package ch.sparkpudding.coreengine.ecs.system;

import ch.sparkpudding.coreengine.Lel;
import ch.sparkpudding.coreengine.api.Input;
import ch.sparkpudding.coreengine.ecs.entity.Entity;
import ch.sparkpudding.coreengine.ecs.system.System;
import ch.sparkpudding.coreengine.utils.Pair;
import java.io.File;
import java.util.Map;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.luaj.vm2.LuaError;
import org.luaj.vm2.LuaValue;
import org.luaj.vm2.lib.jse.CoerceJavaToLua;

public class UpdateSystem
extends System {
    private boolean pausable;
    private LuaValue updateMethod;
    private LuaValue isPausableMethod;

    public UpdateSystem(File file) {
        super(file);
        this.sandboxThread = new Thread(() -> this.sandboxedUpdate());
        this.reload();
    }

    @Override
    protected void readMethodsFromLua() {
        super.readMethodsFromLua();
        this.updateMethod = this.globals.get("update");
        this.isPausableMethod = this.globals.get("isPausable");
        if (this.updateMethod.isnil()) {
            this.updateMethod = null;
        }
    }

    @Override
    public void reload() {
        super.reload();
        if (!this.loadingFailed) {
            this.readMethodsFromLua();
            this.pausable = this.isPausableMethod.isnil() ? false : this.isPausableMethod.call().toboolean();
            this.loadUpdateApis();
            for (Map.Entry entry : this.componentGroups.entrySet()) {
                LuaValue func = this.globals.get("update" + ((String)entry.getKey()).substring(0, 1).toUpperCase() + ((String)entry.getKey()).substring(1));
                if (func == LuaValue.NIL) continue;
                this.componentGroupsLuaFunctions.put((String)entry.getKey(), func);
            }
        }
    }

    private void loadUpdateApis() {
        this.apiTable.set("input", CoerceJavaToLua.coerce(Input.getInstance()));
    }

    public boolean isPausable() {
        return this.pausable;
    }

    private void sandboxedUpdate() {
        try {
            int i = 0;
            while (i < this.sortedEntities.size()) {
                LuaValue func = (LuaValue)this.componentGroupsLuaFunctions.get(((Pair)this.sortedEntities.get(i)).first());
                if (func != null) {
                    func.call(((Entity)((Pair)this.sortedEntities.get(i)).second()).getLuaEntity());
                }
                ++i;
            }
            if (this.updateMethod != null) {
                this.updateMethod.call();
            }
        }
        catch (LuaError error2) {
            Lel.coreEngine.notifyGameError(error2);
        }
        catch (StackOverflowError error3) {
            Lel.coreEngine.notifyGameError(new Exception("Stack overflow in " + this.filepath + ". This sometimes happens when trying to read an inexisting field from a component."));
        }
    }

    public void update() {
        if (!this.loadingFailed) {
            Future<?> future = this.executor.submit(this.sandboxThread);
            try {
                future.get(3L, TimeUnit.SECONDS);
            }
            catch (InterruptedException e) {
                Lel.coreEngine.notifyGameError(new Exception("A LEL internal error occured."));
            }
            catch (ExecutionException e) {
                Lel.coreEngine.notifyGameError(new Exception("A LEL internal error occured."));
            }
            catch (TimeoutException e) {
                future.cancel(true);
                Lel.coreEngine.notifyGameError(new Exception(String.valueOf(this.filepath) + " took more than the " + 3 + " seconds allowed to update."));
            }
        }
    }
}

