/*
 * Decompiled with CFR 0.152.
 */
package ch.sparkpudding.coreengine.ecs.component;

public class Field {
    private FieldType type;
    private String name;
    private Object value;

    public Field(Field field) {
        this.type = field.type;
        this.name = field.name;
        this.value = field.value;
    }

    public Field(String name, String type2, String value) {
        this.name = name;
        this.type = FieldType.valueOf(type2);
        this.setValueFromString(value);
    }

    protected Object clone() throws CloneNotSupportedException {
        return new Field(this);
    }

    public String getName() {
        return this.name;
    }

    public FieldType getType() {
        return this.type;
    }

    public Object getValue() {
        return this.value;
    }

    public int getInt() {
        if (this.value instanceof Double) {
            return ((Double)this.value).intValue();
        }
        return (Integer)this.value;
    }

    public double getDouble() {
        if (this.value instanceof Integer) {
            return ((Integer)this.value).intValue();
        }
        return (Double)this.value;
    }

    public void setValue(Object value) {
        this.value = value;
    }

    public void setValueFromString(String value) {
        switch (this.type) {
            case BOOLEAN: {
                this.setValue(value.toUpperCase().equals("TRUE"));
                break;
            }
            case DOUBLE: {
                this.setValue(Double.parseDouble(value));
                break;
            }
            case STRING: 
            case FILE_PATH: {
                this.setValue(value);
                break;
            }
            case INTEGER: {
                try {
                    this.setValue(Integer.parseInt(value));
                }
                catch (Exception e) {
                    try {
                        this.setValue(Double.parseDouble(value));
                    }
                    catch (Exception e1) {
                        if (this.value != null) break;
                        this.value = 0;
                    }
                }
                break;
            }
            default: {
                System.err.println("Could not set field value from string");
            }
        }
    }

    public static enum FieldType {
        INTEGER,
        DOUBLE,
        STRING,
        FILE_PATH,
        BOOLEAN;

    }
}

