/*
 * Decompiled with CFR 0.152.
 */
package ch.sparkpudding.coreengine.api;

import ch.sparkpudding.coreengine.Lel;
import ch.sparkpudding.coreengine.ResourceLocator;
import java.io.IOException;
import javax.sound.sampled.AudioInputStream;
import javax.sound.sampled.AudioSystem;
import javax.sound.sampled.Clip;
import javax.sound.sampled.LineEvent;
import javax.sound.sampled.LineListener;
import javax.sound.sampled.LineUnavailableException;

public class Sound {
    private static Sound instance;
    private ResourceLocator resourceLocator = Lel.coreEngine.getResourceLocator();
    private static final LineListener stopLineListener;
    private Clip currentMusic;

    static {
        stopLineListener = new LineListener(){

            @Override
            public void update(LineEvent event) {
                if (event.getType() == LineEvent.Type.STOP) {
                    event.getLine().close();
                }
            }
        };
    }

    private Sound() {
    }

    public static Sound getInstance() {
        if (instance == null) {
            instance = new Sound();
        }
        return instance;
    }

    public void playMusic(String name) throws IOException, LineUnavailableException {
        AudioInputStream audioInputStream = this.resourceLocator.getMusic(name);
        if (audioInputStream == null) {
            return;
        }
        audioInputStream.reset();
        if (this.currentMusic != null) {
            this.currentMusic.stop();
            this.currentMusic.close();
            this.currentMusic = null;
        }
        this.currentMusic = AudioSystem.getClip();
        this.currentMusic.open(audioInputStream);
        this.currentMusic.loop(-1);
    }

    public void stopMusic() {
        if (this.currentMusic != null) {
            this.currentMusic.stop();
            this.currentMusic.close();
            this.currentMusic = null;
        }
    }

    public void pauseMusic() {
        if (this.currentMusic != null) {
            this.currentMusic.stop();
        }
    }

    public void resumeMusic() {
        if (this.currentMusic != null) {
            this.currentMusic.start();
        }
    }

    public void play(String name) throws LineUnavailableException, IOException {
        AudioInputStream audioInputStream = this.resourceLocator.getSound(name);
        if (audioInputStream == null) {
            return;
        }
        audioInputStream.reset();
        Clip clip = AudioSystem.getClip();
        clip.open(audioInputStream);
        clip.start();
        clip.addLineListener(stopLineListener);
    }
}

