/*
 * Decompiled with CFR 0.152.
 */
package ch.sparkpudding.coreengine.api;

import ch.sparkpudding.coreengine.Lel;
import ch.sparkpudding.coreengine.utils.Collision;
import java.awt.geom.Point2D;

public class Input {
    private static Input instance;
    private ch.sparkpudding.coreengine.Input input = Lel.coreEngine.getInput();

    private Input() {
    }

    public static Input getInstance() {
        if (instance == null) {
            instance = new Input();
        }
        return instance;
    }

    public boolean isKeyDown(int keyCode) {
        return this.input.isKeyDown(keyCode);
    }

    public boolean isKeyDown(String key) {
        return this.input.isKeyDown(this.keyFromString(key));
    }

    public boolean isMouseButtonDown(int keyCode) {
        return this.input.isMouseButtonDown(keyCode);
    }

    public boolean isMouseClicked() {
        return this.input.isMouseClicked();
    }

    public double getMouseWheelRotation() {
        return this.input.getMouseWheelRotation();
    }

    public Point2D getUIMousePosition() {
        return Lel.coreEngine.panelPositionToGame(this.input.getMousePosition());
    }

    public Point2D getMousePosition() {
        return Lel.coreEngine.panelPositionToWorld(this.input.getMousePosition());
    }

    public Point2D getUIMouseSpeed() {
        return Lel.coreEngine.panelVectorToGame(this.input.getMouseSpeed());
    }

    public Point2D getMouseSpeed() {
        return Lel.coreEngine.panelVectorToWorld(this.input.getMouseSpeed());
    }

    public double getUIMouseX() {
        return this.getUIMousePosition().getX();
    }

    public double getUIMouseY() {
        return this.getUIMousePosition().getY();
    }

    public double getMouseX() {
        return this.getMousePosition().getX();
    }

    public double getMouseY() {
        return this.getMousePosition().getY();
    }

    public double getUIMouseDX() {
        return this.getUIMouseSpeed().getX();
    }

    public double getUIMouseDY() {
        return this.getUIMouseSpeed().getY();
    }

    public double getMouseDX() {
        return this.getMouseSpeed().getX();
    }

    public double getMouseDY() {
        return this.getMouseSpeed().getY();
    }

    public double getMouseClickedX() {
        return Lel.coreEngine.panelPositionToWorld(this.input.getMouseClickedPosition()).getX();
    }

    public double getMouseClickedY() {
        return Lel.coreEngine.panelPositionToWorld(this.input.getMouseClickedPosition()).getY();
    }

    public boolean isMouseInRectangle(double x, double y, double w, double h) {
        Point2D mouseLocation = Lel.coreEngine.panelPositionToWorld(this.input.getMousePosition());
        return Collision.intersectRect(mouseLocation.getX(), mouseLocation.getY(), x, y, w, h);
    }

    public int keyFromString(String str) {
        switch (str.toUpperCase()) {
            case "UP": {
                return 38;
            }
            case "DOWN": {
                return 40;
            }
            case "LEFT": {
                return 37;
            }
            case "RIGHT": {
                return 39;
            }
            case "SHIFT": {
                return 16;
            }
            case "CTRL": {
                return 17;
            }
            case "ESCAPE": {
                return 27;
            }
            case "SPACE": {
                return 32;
            }
        }
        switch (str.toUpperCase().charAt(0)) {
            case 'A': {
                return 65;
            }
            case 'B': {
                return 66;
            }
            case 'C': {
                return 67;
            }
            case 'D': {
                return 68;
            }
            case 'E': {
                return 69;
            }
            case 'F': {
                return 70;
            }
            case 'G': {
                return 71;
            }
            case 'H': {
                return 72;
            }
            case 'I': {
                return 73;
            }
            case 'J': {
                return 74;
            }
            case 'K': {
                return 75;
            }
            case 'L': {
                return 76;
            }
            case 'M': {
                return 77;
            }
            case 'N': {
                return 78;
            }
            case 'O': {
                return 79;
            }
            case 'P': {
                return 80;
            }
            case 'Q': {
                return 81;
            }
            case 'R': {
                return 82;
            }
            case 'S': {
                return 83;
            }
            case 'T': {
                return 84;
            }
            case 'U': {
                return 85;
            }
            case 'V': {
                return 86;
            }
            case 'W': {
                return 87;
            }
            case 'X': {
                return 88;
            }
            case 'Y': {
                return 89;
            }
            case 'Z': {
                return 90;
            }
            case '0': {
                return 48;
            }
            case '1': {
                return 49;
            }
            case '2': {
                return 50;
            }
            case '3': {
                return 51;
            }
            case '4': {
                return 52;
            }
            case '5': {
                return 53;
            }
            case '6': {
                return 54;
            }
            case '7': {
                return 55;
            }
            case '8': {
                return 56;
            }
            case '9': {
                return 57;
            }
        }
        return 0;
    }
}

