/*
 * Decompiled with CFR 0.152.
 */
package ch.sparkpudding.coreengine.api;

import ch.sparkpudding.coreengine.Lel;
import ch.sparkpudding.coreengine.ResourceLocator;
import ch.sparkpudding.coreengine.utils.Pair;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Image;
import org.luaj.vm2.LuaTable;
import org.luaj.vm2.LuaValue;

public class Graphics {
    private static Graphics instance;
    private Graphics2D g2d;
    private ResourceLocator resourceLocator = Lel.coreEngine.getResourceLocator();

    private Graphics() {
    }

    public static Graphics getInstance() {
        if (instance == null) {
            instance = new Graphics();
        }
        return instance;
    }

    public void setGraphicalContext(Graphics2D g2d) {
        this.g2d = g2d;
    }

    public void dispose() {
        this.g2d = null;
    }

    public Graphics2D getContext() {
        return this.g2d;
    }

    public void drawImage(String name, int x, int y, int width, int height) {
        Image img = this.resourceLocator.getTexture(name);
        this.g2d.drawImage(img, x, y, width, height, null);
    }

    public void drawImage(String name, int x, int y, int width, int height, int sx, int sy, int sw, int sh) {
        Image img = this.resourceLocator.getTexture(name);
        this.g2d.drawImage(img, x, y, x + width, y + height, sx, sy, sx + sw, sy + sh, null);
    }

    public void drawImage(String name, LuaTable lpos, LuaTable lsize) {
        Pair<Integer, Integer> pos = this.fromLuaTable(lpos);
        Pair<Integer, Integer> size = this.fromLuaTable(lsize);
        this.drawImage(name, pos.first(), pos.second(), size.first(), size.second());
    }

    public void drawImage(String name, LuaTable lpos, LuaTable lsize, int sx, int sy, int sw, int sh) {
        Pair<Integer, Integer> pos = this.fromLuaTable(lpos);
        Pair<Integer, Integer> size = this.fromLuaTable(lsize);
        this.drawImage(name, pos.first(), pos.second(), size.first(), size.second(), sx, sy, sw, sh);
    }

    public void setColor(Color color) {
        this.g2d.setColor(color);
    }

    public void setColor(int r, int g, int b) {
        this.g2d.setColor(new Color(r, g, b));
    }

    public void setColor(int r, int g, int b, int a) {
        this.g2d.setColor(new Color(r, g, b, a));
    }

    public void setPenWidth(float width) {
        this.g2d.setStroke(new BasicStroke(width));
    }

    public void setAnimatedDashedLine(float width, float spacing, float phase) {
        BasicStroke dashed = new BasicStroke(width, 0, 2, 0.0f, new float[]{spacing}, phase);
        this.g2d.setStroke(dashed);
    }

    public void fillRect(int x, int y, int width, int height) {
        this.g2d.fillRect(x, y, width, height);
    }

    public void fillRect(LuaTable lpos, LuaTable lsize) {
        Pair<Integer, Integer> pos = this.fromLuaTable(lpos);
        Pair<Integer, Integer> size = this.fromLuaTable(lsize);
        this.g2d.fillRect(pos.first(), pos.second(), size.first(), size.second());
    }

    public void drawString(String text, int x, int y) {
        this.g2d.drawString(text, x, y);
    }

    public void drawString(String text, LuaTable lpos) {
        Pair<Integer, Integer> pos = this.fromLuaTable(lpos);
        this.g2d.drawString(text, (int)pos.first(), (int)pos.second());
    }

    public void setBackground(int r, int g, int b) {
        this.g2d.setBackground(new Color(r, g, b));
    }

    public void setBackground(int r, int g, int b, int a) {
        this.g2d.setBackground(new Color(r, g, b, a));
    }

    public void clearRect(int x, int y, int width, int height) {
        this.g2d.clearRect(x, y, width, height);
    }

    public void clearRect(LuaTable lpos, LuaTable lsize) {
        Pair<Integer, Integer> pos = this.fromLuaTable(lpos);
        Pair<Integer, Integer> size = this.fromLuaTable(lsize);
        this.g2d.clearRect(pos.first(), pos.second(), size.first(), size.second());
    }

    public void drawArc(int x, int y, int width, int height, int startAngle, int arcAngle) {
        this.g2d.drawArc(x, y, width, height, startAngle, arcAngle);
    }

    public void drawArc(LuaTable lpos, LuaTable lsize, int startAngle, int arcAngle) {
        Pair<Integer, Integer> pos = this.fromLuaTable(lpos);
        Pair<Integer, Integer> size = this.fromLuaTable(lsize);
        this.g2d.drawArc(pos.first(), pos.second(), size.first(), size.second(), startAngle, arcAngle);
    }

    public void drawLine(int x1, int y1, int x2, int y2) {
        this.g2d.drawLine(x1, y1, x2, y2);
    }

    public void drawLine(LuaTable lp1, LuaTable lp2) {
        Pair<Integer, Integer> p1 = this.fromLuaTable(lp1);
        Pair<Integer, Integer> p2 = this.fromLuaTable(lp2);
        this.g2d.drawLine(p1.first(), p1.second(), p2.first(), p2.second());
    }

    public void drawOval(int x, int y, int width, int height) {
        this.g2d.drawOval(x, y, width, height);
    }

    public void drawOval(LuaTable lpos, LuaTable lsize) {
        Pair<Integer, Integer> pos = this.fromLuaTable(lpos);
        Pair<Integer, Integer> size = this.fromLuaTable(lsize);
        this.g2d.drawOval(pos.first(), pos.second(), size.first(), size.second());
    }

    public void drawPolygon(LuaTable points) {
        int nPoints = points.length();
        System.out.println(nPoints);
        int[] xPoints = new int[nPoints];
        int[] yPoints = new int[nPoints];
        int i = 0;
        while (i < nPoints) {
            xPoints[i] = points.get(i + 1).get(1).toint();
            yPoints[i] = points.get(i + 1).get(2).toint();
            ++i;
        }
        this.g2d.drawPolygon(xPoints, yPoints, nPoints);
    }

    public void fillPolygon(LuaTable points) {
        int nPoints = points.length();
        int[] xPoints = new int[nPoints];
        int[] yPoints = new int[nPoints];
        int i = 0;
        while (i < nPoints) {
            xPoints[i] = points.get(i + 1).get(1).toint();
            yPoints[i] = points.get(i + 1).get(2).toint();
            ++i;
        }
        this.g2d.fillPolygon(xPoints, yPoints, nPoints);
    }

    public void drawRect(int x, int y, int width, int height) {
        this.g2d.drawRect(x, y, width, height);
    }

    public void drawRect(LuaTable lpos, LuaTable lsize) {
        Pair<Integer, Integer> pos = this.fromLuaTable(lpos);
        Pair<Integer, Integer> size = this.fromLuaTable(lsize);
        this.g2d.drawRect(pos.first(), pos.second(), size.first(), size.second());
    }

    public void drawRoundRect(int x, int y, int width, int height, int arcWidth, int arcHeight) {
        this.g2d.drawRoundRect(x, y, width, height, arcWidth, arcHeight);
    }

    public void drawRoundRect(LuaTable lpos, LuaTable lsize, int arcWidth, int arcHeight) {
        Pair<Integer, Integer> pos = this.fromLuaTable(lpos);
        Pair<Integer, Integer> size = this.fromLuaTable(lsize);
        this.g2d.drawRoundRect(pos.first(), pos.second(), size.first(), size.second(), arcWidth, arcHeight);
    }

    public void fillArc(int x, int y, int width, int height, int startAngle, int arcAngle) {
        this.g2d.fillArc(x, y, width, height, startAngle, arcAngle);
    }

    public void fillArc(LuaTable lpos, LuaTable lsize, int startAngle, int arcAngle) {
        Pair<Integer, Integer> pos = this.fromLuaTable(lpos);
        Pair<Integer, Integer> size = this.fromLuaTable(lsize);
        this.g2d.fillArc(pos.first(), pos.second(), size.first(), size.second(), startAngle, arcAngle);
    }

    public void fillOval(int x, int y, int width, int height) {
        this.g2d.fillOval(x, y, width, height);
    }

    public void fillOval(LuaTable lpos, LuaTable lsize) {
        Pair<Integer, Integer> pos = this.fromLuaTable(lpos);
        Pair<Integer, Integer> size = this.fromLuaTable(lsize);
        this.g2d.fillOval(pos.first(), pos.second(), size.first(), size.second());
    }

    public void fillRoundRect(int x, int y, int width, int height, int arcWidth, int arcHeight) {
        this.g2d.fillRoundRect(x, y, width, height, arcWidth, arcHeight);
    }

    public void fillRoundRect(LuaTable lpos, LuaTable lsize, int arcWidth, int arcHeight) {
        Pair<Integer, Integer> pos = this.fromLuaTable(lpos);
        Pair<Integer, Integer> size = this.fromLuaTable(lsize);
        this.g2d.fillRoundRect(pos.first(), pos.second(), size.first(), size.second(), arcWidth, arcHeight);
    }

    private Pair<Integer, Integer> fromLuaTable(LuaTable lpoint) {
        LuaValue firstkey = lpoint.keys()[0];
        if (firstkey.isint()) {
            return new Pair<Integer, Integer>(lpoint.get(1).toint(), lpoint.get(2).toint());
        }
        if (lpoint.keys()[0].toString().length() > 2) {
            return this.fromLuaSize(lpoint);
        }
        return this.fromLuaPoint(lpoint);
    }

    private Pair<Integer, Integer> fromLuaPoint(LuaTable lpoint) {
        return new Pair<Integer, Integer>(lpoint.get("x").toint(), lpoint.get("y").toint());
    }

    private Pair<Integer, Integer> fromLuaSize(LuaTable lpoint) {
        return new Pair<Integer, Integer>(lpoint.get("width").toint(), lpoint.get("height").toint());
    }
}

