/*
 * Decompiled with CFR 0.152.
 */
package ch.sparkpudding.coreengine;

import ch.sparkpudding.coreengine.filereader.LelReader;
import java.awt.Image;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import javax.imageio.ImageIO;
import javax.sound.sampled.AudioInputStream;
import javax.sound.sampled.AudioSystem;
import javax.sound.sampled.UnsupportedAudioFileException;

public class ResourceLocator {
    private LelReader lelReader;
    private Map<String, Image> textures;
    private Map<String, AudioInputStream> sounds;
    private Map<String, AudioInputStream> musics;

    public ResourceLocator(LelReader lelReader) {
        this.lelReader = lelReader;
        try {
            this.loadTextures();
            this.loadSounds();
            this.loadMusics();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void loadTextures() throws IOException {
        this.textures = new HashMap<String, Image>();
        for (File file : this.lelReader.getTextures()) {
            if (file.getName().equals(".keep")) continue;
            this.textures.put(file.getName(), ImageIO.read(file));
        }
    }

    private void loadSounds() throws UnsupportedAudioFileException, IOException {
        this.sounds = new HashMap<String, AudioInputStream>();
        for (File file : this.lelReader.getSounds()) {
            if (file.getName().equals(".keep")) continue;
            AudioInputStream audioInputStream = ResourceLocator.createReusableAudioInputStream(file);
            this.sounds.put(file.getName(), audioInputStream);
        }
    }

    private void loadMusics() throws UnsupportedAudioFileException, IOException {
        this.musics = new HashMap<String, AudioInputStream>();
        for (File file : this.lelReader.getMusics()) {
            if (file.getName().equals(".keep")) continue;
            AudioInputStream audioInputStream = ResourceLocator.createReusableAudioInputStream(file);
            this.musics.put(file.getName(), audioInputStream);
        }
    }

    public Image getTexture(String name) {
        return this.textures.get(name);
    }

    public AudioInputStream getSound(String name) {
        return this.sounds.get(name);
    }

    public AudioInputStream getMusic(String name) {
        return this.musics.get(name);
    }

    private static AudioInputStream createReusableAudioInputStream(File file) throws IOException, UnsupportedAudioFileException {
        try (AudioInputStream ais = null;){
            AudioInputStream reusableAis;
            ais = AudioSystem.getAudioInputStream(file);
            byte[] buffer = new byte[32768];
            int read = 0;
            ByteArrayOutputStream baos = new ByteArrayOutputStream(buffer.length);
            while ((read = ais.read(buffer, 0, buffer.length)) != -1) {
                baos.write(buffer, 0, read);
            }
            AudioInputStream audioInputStream = reusableAis = new AudioInputStream(new ByteArrayInputStream(baos.toByteArray()), ais.getFormat(), -1L);
            return audioInputStream;
        }
    }
}

