/*
 * Decompiled with CFR 0.152.
 */
package ch.sparkpudding.coreengine;

import ch.sparkpudding.coreengine.Lel;
import ch.sparkpudding.coreengine.utils.Collision;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.geom.AffineTransform;
import java.awt.geom.Point2D;

public class Camera {
    private static final double SPRING_MIN_FORCE_REQUIRED = 0.001;
    private AffineTransform transformationState;
    private Mode translateMode = Mode.SPRING;
    private Rectangle boundary;
    private Point2D position = new Point2D.Double(0.0, 0.0);
    private Point2D targetPosition = new Point2D.Double(0.0, 0.0);
    private Point2D springTranslateForce = new Point2D.Double(0.0, 0.0);
    private Point2D springTranslateConstant = new Point2D.Double(1.7, 1.7);
    private Point2D springTranslateSpeedCoeff = new Point2D.Double(0.2, 0.2);
    private Point2D smoothSpeedCoeff = new Point2D.Double(0.1, 0.1);
    private Point2D linearSpeedDelta = new Point2D.Double(15.0, 15.0);
    private float scaling = 1.0f;
    private float targetScaling = 1.0f;
    private float smoothScaleSpeedCoeff = 0.1f;
    private Point2D scalingPoint = new Point2D.Double(Lel.coreEngine.getGameWidth() / 2.0, Lel.coreEngine.getGameHeight() / 2.0);
    private float shakeIntensity = 1.0f;
    private int shakeDurationLeft = 0;

    public void update() {
        double x = this.position.getX();
        double y = this.position.getY();
        switch (this.translateMode) {
            case NO_FOLLOW: {
                break;
            }
            case INSTANT: {
                x = this.targetPosition.getX();
                y = this.targetPosition.getY();
                break;
            }
            case LINEAR: {
                if (Math.abs(this.targetPosition.getX() - x) > 1.0) {
                    if (this.targetPosition.getX() > x) {
                        x += this.linearSpeedDelta.getX();
                        if (this.targetPosition.getX() < x) {
                            x = this.targetPosition.getX();
                        }
                    } else {
                        x -= this.linearSpeedDelta.getX();
                        if (this.targetPosition.getX() > x) {
                            x = this.targetPosition.getX();
                        }
                    }
                }
                if (!(Math.abs(this.targetPosition.getY() - y) > 1.0)) break;
                if (this.targetPosition.getY() > y) {
                    y += this.linearSpeedDelta.getY();
                    if (!(this.targetPosition.getY() < y)) break;
                    y = this.targetPosition.getY();
                    break;
                }
                y -= this.linearSpeedDelta.getY();
                if (!(this.targetPosition.getY() > y)) break;
                y = this.targetPosition.getY();
                break;
            }
            case SMOOTH: {
                x += (this.targetPosition.getX() - x) * this.smoothSpeedCoeff.getX();
                y += (this.targetPosition.getY() - y) * this.smoothSpeedCoeff.getY();
                break;
            }
            case SPRING: {
                double forceX = this.springTranslateForce.getX();
                double forceY = this.springTranslateForce.getY();
                forceX += (this.targetPosition.getX() - x) * this.springTranslateSpeedCoeff.getX();
                forceY += (this.targetPosition.getY() - y) * this.springTranslateSpeedCoeff.getY();
                forceX /= this.springTranslateConstant.getX();
                forceY /= this.springTranslateConstant.getY();
                if (Math.abs(forceX) < 0.001) {
                    forceX = 0.0;
                }
                if (Math.abs(forceY) < 0.001) {
                    forceY = 0.0;
                }
                x += forceX;
                y += forceY;
                this.springTranslateForce.setLocation(forceX, forceY);
            }
        }
        float newTargetScaling = this.scaling + (this.targetScaling - this.scaling) * this.smoothScaleSpeedCoeff;
        float relativeScaling = newTargetScaling / this.scaling;
        x = x * (double)relativeScaling + this.scalingPoint.getX() * (double)(relativeScaling - 1.0f);
        y = y * (double)relativeScaling + this.scalingPoint.getY() * (double)(relativeScaling - 1.0f);
        if (this.boundary != null) {
            if (this.boundary.getWidth() * (double)this.scaling >= Lel.coreEngine.getGameWidth()) {
                x = Math.max(x, this.boundary.getX() * (double)this.scaling);
                x = Math.min(x, (this.boundary.getWidth() + this.boundary.getX()) * (double)this.scaling - Lel.coreEngine.getGameWidth());
            } else {
                x = -Lel.coreEngine.getGameWidth() / 2.0 + (double)this.scaling * this.boundary.getWidth() / 2.0 + this.boundary.getX() * (double)this.scaling;
            }
            if (this.boundary.getHeight() * (double)this.scaling >= Lel.coreEngine.getGameHeight()) {
                y = Math.max(y, this.boundary.getY() * (double)this.scaling);
                y = Math.min(y, (this.boundary.getHeight() + this.boundary.getY()) * (double)this.scaling - Lel.coreEngine.getGameHeight());
            } else {
                y = -Lel.coreEngine.getGameHeight() / 2.0 + (double)this.scaling * this.boundary.getHeight() / 2.0 + this.boundary.getY() * (double)this.scaling;
            }
        }
        if (this.shakeDurationLeft > 0) {
            --this.shakeDurationLeft;
            x += 2.0 * (Math.random() - 0.5) * (double)this.shakeIntensity;
            y += 2.0 * (Math.random() - 0.5) * (double)this.shakeIntensity;
        }
        this.position.setLocation(x, y);
        this.scaling = newTargetScaling;
    }

    private void resetForces() {
        this.springTranslateForce = new Point2D.Double(0.0, 0.0);
    }

    public void applyTransforms(Graphics2D g2d) {
        this.transformationState = g2d.getTransform();
        g2d.translate(-this.position.getX(), -this.position.getY());
        g2d.scale(this.scaling, this.scaling);
    }

    public void resetTransforms(Graphics2D g2d) {
        g2d.setTransform(this.transformationState);
    }

    public void setWorldPosition(double x, double y) {
        this.position.setLocation(x * (double)this.scaling, y * (double)this.scaling);
        this.targetPosition.setLocation(this.position.getX(), this.position.getY());
        this.resetForces();
    }

    public void setPosition(double x, double y) {
        this.position.setLocation(x, y);
    }

    public void setScaling(float scaling) {
        this.scaling = scaling;
    }

    public void centerTargetAt(float x, float y, float w, float h) {
        this.targetPosition.setLocation((double)(x * this.scaling) + ((double)(w * this.scaling) - Lel.coreEngine.getGameWidth()) / 2.0, (double)(y * this.scaling) + ((double)(h * this.scaling) - Lel.coreEngine.getGameHeight()) / 2.0);
    }

    public void centerAt(float x, float y, float w, float h) {
        this.position.setLocation((double)(x * this.scaling) + ((double)(w * this.scaling) - Lel.coreEngine.getGameWidth()) / 2.0, (double)(y * this.scaling) + ((double)(h * this.scaling) - Lel.coreEngine.getGameHeight()) / 2.0);
        this.targetPosition.setLocation(this.position.getX(), this.position.getY());
        this.resetForces();
    }

    public void centerAt(float x, float y) {
        this.centerAt(x, y, 0.0f, 0.0f);
    }

    public void centerTargetAt(float x, float y) {
        this.centerTargetAt(x, y, 0.0f, 0.0f);
    }

    public void setTargetPosition(float x, float y) {
        this.targetPosition.setLocation(x, y);
    }

    public void setTargetScaling(float s) {
        this.targetScaling = s;
    }

    public void setTranslateMode(Mode mode) {
        this.translateMode = mode;
    }

    public void setBoundary(Rectangle boundary) {
        this.boundary = boundary;
    }

    public void setSpringTranslateForce(Point2D springTranslateForce) {
        this.springTranslateForce = springTranslateForce;
    }

    public void setSpringTranslateConstant(Point2D springTranslateConstant) {
        this.springTranslateConstant = springTranslateConstant;
    }

    public void setSpringTranslateSpeedCoeff(Point2D springTranslateSpeedCoeff) {
        this.springTranslateSpeedCoeff = springTranslateSpeedCoeff;
    }

    public void setSmoothSpeedCoeff(Point2D smoothSpeedCoeff) {
        this.smoothSpeedCoeff = smoothSpeedCoeff;
    }

    public void setLinearSpeedDelta(Point2D linearSpeedDelta) {
        this.linearSpeedDelta = linearSpeedDelta;
    }

    public void setSmoothScaleSpeedCoeff(float smoothScaleSpeedCoeff) {
        this.smoothScaleSpeedCoeff = smoothScaleSpeedCoeff;
    }

    public void setScalingPoint(Point2D scalingPoint) {
        this.scalingPoint = scalingPoint;
    }

    public void shake(float intensity, int duration) {
        this.shakeIntensity = intensity;
        this.shakeDurationLeft = duration;
    }

    public Point2D getPosition() {
        return this.position;
    }

    public float getScaling() {
        return this.scaling;
    }

    public void setTargetToPosition() {
        this.targetPosition.setLocation(this.position.getX(), this.position.getY());
        this.resetForces();
    }

    public boolean isInView(double x, double y, double width, double height) {
        double cx = this.position.getX() / (double)this.scaling;
        double cy = this.position.getY() / (double)this.scaling;
        double cw = Lel.coreEngine.getGameWidth() / (double)this.scaling;
        double ch = Lel.coreEngine.getGameHeight() / (double)this.scaling;
        return Collision.rectIntersectRect(x, y, width, height, cx, cy, cw, ch);
    }

    public float getTargetScaling() {
        return this.targetScaling;
    }

    public Point2D getScalingPoint() {
        return this.scalingPoint;
    }

    public Mode getTranslateMode() {
        return this.translateMode;
    }

    public static enum Mode {
        NO_FOLLOW,
        INSTANT,
        LINEAR,
        SMOOTH,
        SPRING;

    }
}

